/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.ApiClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.nodes.HotThreadsRequest;
import org.opensearch.client.opensearch.nodes.HotThreadsResponse;
import org.opensearch.client.opensearch.nodes.NodesInfoRequest;
import org.opensearch.client.opensearch.nodes.NodesInfoResponse;
import org.opensearch.client.opensearch.nodes.NodesStatsRequest;
import org.opensearch.client.opensearch.nodes.NodesStatsResponse;
import org.opensearch.client.opensearch.nodes.NodesUsageRequest;
import org.opensearch.client.opensearch.nodes.NodesUsageResponse;
import org.opensearch.client.opensearch.nodes.ReloadSecureSettingsRequest;
import org.opensearch.client.opensearch.nodes.ReloadSecureSettingsResponse;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.util.ObjectBuilder;

public class OpenSearchNodesAsyncClient
extends ApiClient<OpenSearchTransport, OpenSearchNodesAsyncClient> {
    public OpenSearchNodesAsyncClient(OpenSearchTransport transport) {
        super(transport, null);
    }

    public OpenSearchNodesAsyncClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public OpenSearchNodesAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new OpenSearchNodesAsyncClient((OpenSearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<HotThreadsResponse> hotThreads(HotThreadsRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)HotThreadsRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<HotThreadsResponse> hotThreads(Function<HotThreadsRequest.Builder, ObjectBuilder<HotThreadsRequest>> fn) throws IOException, OpenSearchException {
        return this.hotThreads(fn.apply(new HotThreadsRequest.Builder()).build());
    }

    public CompletableFuture<HotThreadsResponse> hotThreads() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new HotThreadsRequest.Builder().build(), HotThreadsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<NodesInfoResponse> info(NodesInfoRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)NodesInfoRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<NodesInfoResponse> info(Function<NodesInfoRequest.Builder, ObjectBuilder<NodesInfoRequest>> fn) throws IOException, OpenSearchException {
        return this.info(fn.apply(new NodesInfoRequest.Builder()).build());
    }

    public CompletableFuture<NodesInfoResponse> info() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new NodesInfoRequest.Builder().build(), NodesInfoRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<ReloadSecureSettingsResponse> reloadSecureSettings(ReloadSecureSettingsRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ReloadSecureSettingsRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<ReloadSecureSettingsResponse> reloadSecureSettings(Function<ReloadSecureSettingsRequest.Builder, ObjectBuilder<ReloadSecureSettingsRequest>> fn) throws IOException, OpenSearchException {
        return this.reloadSecureSettings(fn.apply(new ReloadSecureSettingsRequest.Builder()).build());
    }

    public CompletableFuture<ReloadSecureSettingsResponse> reloadSecureSettings() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new ReloadSecureSettingsRequest.Builder().build(), ReloadSecureSettingsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<NodesStatsResponse> stats(NodesStatsRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)NodesStatsRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<NodesStatsResponse> stats(Function<NodesStatsRequest.Builder, ObjectBuilder<NodesStatsRequest>> fn) throws IOException, OpenSearchException {
        return this.stats(fn.apply(new NodesStatsRequest.Builder()).build());
    }

    public CompletableFuture<NodesStatsResponse> stats() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new NodesStatsRequest.Builder().build(), NodesStatsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<NodesUsageResponse> usage(NodesUsageRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)NodesUsageRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<NodesUsageResponse> usage(Function<NodesUsageRequest.Builder, ObjectBuilder<NodesUsageRequest>> fn) throws IOException, OpenSearchException {
        return this.usage(fn.apply(new NodesUsageRequest.Builder()).build());
    }

    public CompletableFuture<NodesUsageResponse> usage() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new NodesUsageRequest.Builder().build(), NodesUsageRequest._ENDPOINT, this.transportOptions);
    }
}

