/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.migration;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MessageV3Migration
implements Migration {
    private static final int CONCURRENCY = 50;
    public static final Logger LOGGER = LoggerFactory.getLogger(MessageV3Migration.class);
    public static final TaskType TYPE = TaskType.of((String)"cassandra-message-v3-migration");
    private final CassandraMessageDAO daoV2;
    private final CassandraMessageDAOV3 daoV3;

    @Inject
    public MessageV3Migration(CassandraMessageDAO daoV2, CassandraMessageDAOV3 daoV3) {
        this.daoV2 = daoV2;
        this.daoV3 = daoV3;
    }

    public void apply() {
        this.daoV2.list().flatMap(this::migrate, 50).doOnError(t -> LOGGER.error("Error while performing migration", t)).blockLast();
    }

    private Mono<Void> migrate(MessageRepresentation messageRepresentation) {
        return this.daoV3.save(messageRepresentation).then(this.daoV2.delete((CassandraMessageId)messageRepresentation.getMessageId())).onErrorResume(error -> this.handleErrorMigrate(messageRepresentation, (Throwable)error)).then();
    }

    private Mono<Void> handleErrorMigrate(MessageRepresentation messageRepresentation, Throwable throwable) {
        LOGGER.error("Error while performing migration for {}", (Object)messageRepresentation.getMessageId(), (Object)throwable);
        return Mono.error((Throwable)throwable);
    }

    public Task asTask() {
        return new MessageV3MigrationTask(this);
    }

    AdditionalInformation getAdditionalInformation() {
        return new AdditionalInformation(Clock.systemUTC().instant());
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;

        public AdditionalInformation(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    static class MessageV3MigrationTask
    implements Task {
        private final MessageV3Migration migration;

        MessageV3MigrationTask(MessageV3Migration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.migration.getAdditionalInformation());
        }
    }
}

