/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.api;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.util.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import net.jcip.annotations.Immutable;

@Immutable
public class ResolveClaimsVerifier
extends DefaultJWTClaimsVerifier {
    public ResolveClaimsVerifier() {
        super(null, new HashSet<String>(Arrays.asList("iss", "sub", "iat", "exp", "metadata")));
    }

    public void verify(JWTClaimsSet claimsSet, SecurityContext context) throws BadJWTException {
        super.verify(claimsSet, context);
        Date now = new Date();
        if (!DateUtils.isBefore((Date)claimsSet.getIssueTime(), (Date)now, (long)this.getMaxClockSkew())) {
            throw new BadJWTException("JWT issue time after current time");
        }
    }
}

