/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.stage;

import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.connection.EventSupplier;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.stage.PipeTaskStage;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeSubtask;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.processor.PipeProcessorSubtask;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskProcessorStage
extends PipeTaskStage {
    private final PipeProcessorSubtaskExecutor executor;
    private final PipeProcessorSubtask pipeProcessorSubtask;

    public PipeTaskProcessorStage(String pipeName, long creationTime, PipeParameters pipeProcessorParameters, int regionId, EventSupplier pipeExtractorInputEventSupplier, UnboundedBlockingPendingQueue<Event> pipeConnectorOutputPendingQueue, PipeProcessorSubtaskExecutor executor, PipeTaskMeta pipeTaskMeta, boolean forceTabletFormat, boolean skipParsing) {
        PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskProcessorRuntimeEnvironment(pipeName, creationTime, regionId, pipeTaskMeta));
        PipeProcessor pipeProcessor = StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(regionId)) || PipeRuntimeMeta.isSourceExternal((int)regionId) ? PipeDataNodeAgent.plugin().dataRegion().getConfiguredProcessor(pipeProcessorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()), pipeProcessorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration) : PipeDataNodeAgent.plugin().schemaRegion().getConfiguredProcessor(pipeProcessorParameters.getStringOrDefault("processor", BuiltinPipePlugin.DO_NOTHING_PROCESSOR.getPipePluginName()), pipeProcessorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration);
        String taskId = pipeName + "_" + regionId + "_" + creationTime;
        boolean isUsedForConsensusPipe = pipeName.contains("__consensus.");
        PipeEventCollector pipeConnectorOutputEventCollector = new PipeEventCollector(pipeConnectorOutputPendingQueue, creationTime, regionId, forceTabletFormat, skipParsing, isUsedForConsensusPipe);
        this.pipeProcessorSubtask = new PipeProcessorSubtask(taskId, pipeName, creationTime, regionId, pipeExtractorInputEventSupplier, pipeProcessor, pipeConnectorOutputEventCollector);
        this.executor = executor;
    }

    public void createSubtask() throws PipeException {
        this.executor.register((PipeSubtask)this.pipeProcessorSubtask);
    }

    public void startSubtask() throws PipeException {
        this.executor.start(this.pipeProcessorSubtask.getTaskID());
    }

    public void stopSubtask() throws PipeException {
        this.executor.stop(this.pipeProcessorSubtask.getTaskID());
    }

    public void dropSubtask() throws PipeException {
        this.executor.deregister(this.pipeProcessorSubtask.getTaskID());
    }
}

