/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.DiskAlignedChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.DiskAlignedChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.MemAlignedChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.MemChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.tsfile.file.metadata.AbstractAlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TableDeviceTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.IPageReader;

public class FileLoaderUtils {
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    private FileLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeseriesMetadata loadTimeSeriesMetadata(TsFileResource resource, NonAlignedFullPath seriesPath, FragmentInstanceContext context, Filter globalTimeFilter, Set<String> allSensors, boolean isSeq) throws IOException {
        long t1 = System.nanoTime();
        boolean loadFromMem = false;
        try {
            TimeseriesMetadata timeSeriesMetadata;
            if (resource.isClosed()) {
                timeSeriesMetadata = TimeSeriesMetadataCache.getInstance().get(resource.getTsFilePath(), new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFileID(), seriesPath.getDeviceId(), seriesPath.getMeasurement()), allSensors, context.ignoreNotExistsDevice() || resource.getTimeIndexType() == 2, context.isDebug(), context);
                if (timeSeriesMetadata != null) {
                    long t2 = System.nanoTime();
                    List<ModEntry> pathModifications = context.getPathModifications(resource, seriesPath.getDeviceId(), seriesPath.getMeasurement());
                    timeSeriesMetadata.setModified(!pathModifications.isEmpty());
                    timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskChunkMetadataLoader(resource, context, globalTimeFilter, pathModifications));
                    int modificationCount = pathModifications.size();
                    if (modificationCount != 0) {
                        long costTime = System.nanoTime() - t2;
                        context.getQueryStatistics().getNonAlignedTimeSeriesMetadataModificationCount().getAndAdd(modificationCount);
                        context.getQueryStatistics().getNonAlignedTimeSeriesMetadataModificationTime().getAndAdd(costTime);
                    }
                }
            } else {
                loadFromMem = true;
                timeSeriesMetadata = (TimeseriesMetadata)resource.getTimeSeriesMetadata((IFullPath)seriesPath);
                if (timeSeriesMetadata != null) {
                    timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemChunkMetadataLoader(resource, seriesPath, context, globalTimeFilter));
                }
            }
            if (timeSeriesMetadata != null) {
                if (timeSeriesMetadata.getStatistics().getStartTime() > timeSeriesMetadata.getStatistics().getEndTime()) {
                    TimeseriesMetadata timeseriesMetadata = null;
                    return timeseriesMetadata;
                }
                if (globalTimeFilter != null && globalTimeFilter.canSkip((IMetadata)timeSeriesMetadata)) {
                    TimeseriesMetadata timeseriesMetadata = null;
                    return timeseriesMetadata;
                }
            }
            TimeseriesMetadata timeseriesMetadata = timeSeriesMetadata;
            return timeseriesMetadata;
        }
        finally {
            long costTime = System.nanoTime() - t1;
            if (loadFromMem) {
                if (isSeq) {
                    context.getQueryStatistics().getLoadTimeSeriesMetadataMemSeqCount().getAndAdd(1L);
                    context.getQueryStatistics().getLoadTimeSeriesMetadataMemSeqTime().getAndAdd(costTime);
                } else {
                    context.getQueryStatistics().getLoadTimeSeriesMetadataMemUnSeqCount().getAndAdd(1L);
                    context.getQueryStatistics().getLoadTimeSeriesMetadataMemUnSeqTime().getAndAdd(costTime);
                }
            } else if (isSeq) {
                context.getQueryStatistics().getLoadTimeSeriesMetadataDiskSeqCount().getAndAdd(1L);
                context.getQueryStatistics().getLoadTimeSeriesMetadataDiskSeqTime().getAndAdd(costTime);
            } else {
                context.getQueryStatistics().getLoadTimeSeriesMetadataDiskUnSeqCount().getAndAdd(1L);
                context.getQueryStatistics().getLoadTimeSeriesMetadataDiskUnSeqTime().getAndAdd(costTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractAlignedTimeSeriesMetadata loadAlignedTimeSeriesMetadata(TsFileResource resource, AlignedFullPath alignedPath, FragmentInstanceContext context, Filter globalTimeFilter, boolean isSeq, boolean ignoreAllNullRows) throws IOException {
        long t1 = System.nanoTime();
        boolean loadFromMem = false;
        try {
            AbstractAlignedTimeSeriesMetadata alignedTimeSeriesMetadata;
            if (resource.isClosed()) {
                alignedTimeSeriesMetadata = FileLoaderUtils.loadAlignedTimeSeriesMetadataFromDisk(resource, alignedPath, context, globalTimeFilter, ignoreAllNullRows);
            } else {
                loadFromMem = true;
                alignedTimeSeriesMetadata = (AbstractAlignedTimeSeriesMetadata)resource.getTimeSeriesMetadata((IFullPath)alignedPath);
                if (alignedTimeSeriesMetadata != null) {
                    alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemAlignedChunkMetadataLoader(resource, alignedPath, context, globalTimeFilter, ignoreAllNullRows));
                }
            }
            if (alignedTimeSeriesMetadata != null) {
                if (alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime() > alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime()) {
                    AbstractAlignedTimeSeriesMetadata abstractAlignedTimeSeriesMetadata = null;
                    return abstractAlignedTimeSeriesMetadata;
                }
                if (globalTimeFilter != null && globalTimeFilter.canSkip((IMetadata)alignedTimeSeriesMetadata)) {
                    AbstractAlignedTimeSeriesMetadata abstractAlignedTimeSeriesMetadata = null;
                    return abstractAlignedTimeSeriesMetadata;
                }
            }
            AbstractAlignedTimeSeriesMetadata abstractAlignedTimeSeriesMetadata = alignedTimeSeriesMetadata;
            return abstractAlignedTimeSeriesMetadata;
        }
        finally {
            long costTime = System.nanoTime() - t1;
            if (loadFromMem) {
                if (isSeq) {
                    context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemSeqCount().getAndAdd(1L);
                    context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemSeqTime().getAndAdd(costTime);
                } else {
                    context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemUnSeqCount().getAndAdd(1L);
                    context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemUnSeqTime().getAndAdd(costTime);
                }
            } else if (isSeq) {
                context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskSeqCount().getAndAdd(1L);
                context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskSeqTime().getAndAdd(costTime);
            } else {
                context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskUnSeqCount().getAndAdd(1L);
                context.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskUnSeqTime().getAndAdd(costTime);
            }
        }
    }

    private static AbstractAlignedTimeSeriesMetadata loadAlignedTimeSeriesMetadataFromDisk(TsFileResource resource, AlignedFullPath alignedPath, FragmentInstanceContext context, Filter globalTimeFilter, boolean ignoreAllNullRows) throws IOException {
        AbstractAlignedTimeSeriesMetadata alignedTimeSeriesMetadata = null;
        TimeSeriesMetadataCache cache = TimeSeriesMetadataCache.getInstance();
        List valueMeasurementList = alignedPath.getMeasurementList();
        Set allSensors = alignedPath.getAllSensors();
        boolean isDebug = context.isDebug();
        String filePath = resource.getTsFilePath();
        IDeviceID deviceId = alignedPath.getDeviceId();
        TimeseriesMetadata timeColumn = cache.get(filePath, new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFileID(), deviceId, ""), allSensors, context.ignoreNotExistsDevice() || resource.getTimeIndexType() == 2, isDebug, context);
        if (timeColumn != null) {
            if (valueMeasurementList.isEmpty()) {
                alignedTimeSeriesMetadata = FileLoaderUtils.setModifications(resource, timeColumn, Collections.emptyList(), alignedPath, context, globalTimeFilter, false);
            } else {
                ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>(valueMeasurementList.size());
                boolean exist = false;
                for (String valueMeasurement : valueMeasurementList) {
                    TimeseriesMetadata valueColumn = cache.get(filePath, new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFileID(), deviceId, valueMeasurement), allSensors, context.ignoreNotExistsDevice() || resource.getTimeIndexType() == 2, isDebug, context);
                    exist = exist || valueColumn != null;
                    valueTimeSeriesMetadataList.add(valueColumn);
                }
                if (!ignoreAllNullRows || exist) {
                    alignedTimeSeriesMetadata = FileLoaderUtils.setModifications(resource, timeColumn, valueTimeSeriesMetadataList, alignedPath, context, globalTimeFilter, ignoreAllNullRows);
                }
            }
        }
        return alignedTimeSeriesMetadata;
    }

    private static AbstractAlignedTimeSeriesMetadata setModifications(TsFileResource resource, TimeseriesMetadata timeColumnMetadata, List<TimeseriesMetadata> valueColumnMetadataList, AlignedFullPath alignedPath, QueryContext context, Filter globalTimeFilter, boolean ignoreAllNullRows) {
        long startTime = System.nanoTime();
        List<ModEntry> timeModifications = context.getPathModifications(resource, alignedPath.getDeviceId(), timeColumnMetadata.getMeasurementId());
        if (ModificationUtils.isAllDeletedByMods(timeModifications, timeColumnMetadata.getStatistics().getStartTime(), timeColumnMetadata.getStatistics().getEndTime())) {
            return null;
        }
        boolean modified = !timeModifications.isEmpty();
        timeColumnMetadata.setModified(modified);
        context.getQueryStatistics().getAlignedTimeSeriesMetadataModificationCount().getAndAdd(timeModifications.size());
        boolean hasNonNullValueColumns = false;
        ArrayList<List<ModEntry>> valueColumnsModifications = new ArrayList<List<ModEntry>>();
        int size = valueColumnMetadataList.size();
        for (int i = 0; i < size; ++i) {
            TimeseriesMetadata valueColumnMetadata = valueColumnMetadataList.get(i);
            if (valueColumnMetadata != null) {
                List<ModEntry> modifications = context.getPathModifications(resource, alignedPath.getDeviceId(), valueColumnMetadata.getMeasurementId());
                valueColumnMetadata.setModified(!modifications.isEmpty());
                valueColumnsModifications.add(modifications);
                modified = modified || !modifications.isEmpty();
                context.getQueryStatistics().getAlignedTimeSeriesMetadataModificationCount().getAndAdd(modifications.size());
                if (ModificationUtils.isAllDeletedByMods(modifications, valueColumnMetadata.getStatistics().getStartTime(), valueColumnMetadata.getStatistics().getEndTime())) {
                    valueColumnMetadataList.set(i, null);
                    continue;
                }
                hasNonNullValueColumns = true;
                continue;
            }
            valueColumnsModifications.add(Collections.emptyList());
        }
        if (ignoreAllNullRows && !hasNonNullValueColumns) {
            return null;
        }
        timeColumnMetadata.setModified(modified);
        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata = ignoreAllNullRows ? new AlignedTimeSeriesMetadata(timeColumnMetadata, valueColumnMetadataList) : new TableDeviceTimeSeriesMetadata(timeColumnMetadata, valueColumnMetadataList);
        alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, context, globalTimeFilter, timeModifications, valueColumnsModifications, ignoreAllNullRows));
        long costTime = System.nanoTime() - startTime;
        context.getQueryStatistics().getAlignedTimeSeriesMetadataModificationTime().getAndAdd(costTime);
        return alignedTimeSeriesMetadata;
    }

    public static List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        return timeSeriesMetadata.loadChunkMetadataList();
    }

    public static List<IPageReader> loadPageReaderList(IChunkMetadata chunkMetaData, Filter globalTimeFilter) throws IOException {
        Preconditions.checkArgument((chunkMetaData != null ? 1 : 0) != 0, (Object)"Can't init null chunkMeta");
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        IChunkReader chunkReader = chunkLoader.getChunkReader(chunkMetaData, globalTimeFilter);
        return chunkReader.loadPageReaderList();
    }

    public static long getTimestampInFileName(IChunkMetadata chunkMetaData) {
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        if (chunkLoader instanceof DiskChunkLoader) {
            return ((DiskChunkLoader)chunkLoader).getTsFileID().getTimestamp();
        }
        if (chunkLoader instanceof DiskAlignedChunkLoader) {
            return ((DiskAlignedChunkLoader)chunkLoader).getTsFileID().getTimestamp();
        }
        return Long.MAX_VALUE;
    }
}

