/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.legacy;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.sink.payload.legacy.PipeData;
import org.apache.iotdb.db.pipe.sink.payload.legacy.TsFilePipeData;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBLegacyPipeReceiverAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBLegacyPipeReceiverAgent.class);
    private static final String PATCH_SUFFIX = ".patch";
    private final ThreadLocal<Long> currentConnectionId = new ThreadLocal();
    private final Map<Long, SyncIdentityInfo> connectionIdToIdentityInfoMap = new ConcurrentHashMap<Long, SyncIdentityInfo>();
    private final Map<Long, Map<String, Long>> connectionIdToStartIndexRecord = new ConcurrentHashMap<Long, Map<String, Long>>();
    private final Map<String, String> registeredDatabase = new ConcurrentHashMap<String, String>();
    private final AtomicLong connectionIdGenerator = new AtomicLong();
    private static final String RECEIVER_DIR_NAME = "receiver";
    private static final String FILE_DATA_DIR_NAME = "file-data";

    public void handleClientExit() {
        if (this.currentConnectionId.get() != null) {
            long id = this.currentConnectionId.get();
            this.connectionIdToIdentityInfoMap.remove(id);
            this.connectionIdToStartIndexRecord.remove(id);
            this.currentConnectionId.remove();
        }
    }

    public TSStatus handshake(TSyncIdentityInfo syncIdentityInfo, String remoteAddress, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        SyncIdentityInfo identityInfo = new SyncIdentityInfo(syncIdentityInfo, remoteAddress);
        LOGGER.info("Invoke handshake method from client ip = {}", (Object)identityInfo.getRemoteAddress());
        if (!new File(IoTDBLegacyPipeReceiverAgent.getFileDataDir(identityInfo)).exists()) {
            new File(IoTDBLegacyPipeReceiverAgent.getFileDataDir(identityInfo)).mkdirs();
        }
        this.createConnection(identityInfo);
        if (!StringUtils.isEmpty((CharSequence)identityInfo.getDatabase()) && !this.registerDatabase(identityInfo.getDatabase(), partitionFetcher, schemaFetcher)) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)String.format("Auto register database %s error.", identityInfo.getDatabase()));
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private void createConnection(SyncIdentityInfo identityInfo) {
        long connectionId = this.connectionIdGenerator.incrementAndGet();
        this.currentConnectionId.set(connectionId);
        this.connectionIdToIdentityInfoMap.put(connectionId, identityInfo);
    }

    private boolean registerDatabase(String database, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        if (this.registeredDatabase.containsKey(database)) {
            return true;
        }
        try {
            DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
            statement.setDatabasePath(new PartialPath(database));
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().executeForTreeModel(statement, queryId, new SessionInfo(0L, AuthorityChecker.SUPER_USER, ZoneId.systemDefault()), "", partitionFetcher, schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), false);
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_CONFLICT.getStatusCode()) {
                LOGGER.error("Create Database error, statement: {}, result status : {}.", (Object)statement, (Object)result.status);
                return false;
            }
        }
        catch (IllegalPathException e) {
            LOGGER.error("Parse database PartialPath {} error", (Object)database, (Object)e);
            return false;
        }
        this.registeredDatabase.put(database, "");
        return true;
    }

    public TSStatus transportPipeData(ByteBuffer buff) throws TException {
        PipeData pipeData;
        SyncIdentityInfo identityInfo = this.getCurrentSyncIdentityInfo();
        if (identityInfo == null) {
            throw new TException("Thrift connection is not alive.");
        }
        LOGGER.debug("Invoke transportPipeData method from client ip = {}", (Object)identityInfo.getRemoteAddress());
        String fileDir = IoTDBLegacyPipeReceiverAgent.getFileDataDir(identityInfo);
        try {
            int length = buff.remaining();
            byte[] byteArray = new byte[length];
            buff.get(byteArray);
            pipeData = PipeData.createPipeData(byteArray);
            if (pipeData instanceof TsFilePipeData) {
                TsFilePipeData tsFilePipeData = (TsFilePipeData)pipeData;
                tsFilePipeData.setDatabase(identityInfo.getDatabase());
                this.handleTsFilePipeData(tsFilePipeData, fileDir);
            }
        }
        catch (IOException e) {
            LOGGER.error("Pipe data transport error, {}", (Object)e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)("Pipe data transport error, " + e.getMessage()));
        }
        LOGGER.info("Start load pipeData with serialize number {} and type {},value={}", new Object[]{pipeData.getSerialNumber(), pipeData.getPipeDataType(), pipeData});
        try {
            pipeData.createLoader().load();
            LOGGER.info("Load pipeData with serialize number {} successfully.", (Object)pipeData.getSerialNumber());
        }
        catch (PipeException e) {
            LOGGER.error("Fail to load pipeData because {}.", (Object)e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)("Fail to load pipeData because " + e.getMessage()));
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private SyncIdentityInfo getCurrentSyncIdentityInfo() {
        Long id = this.currentConnectionId.get();
        if (id != null) {
            return this.connectionIdToIdentityInfoMap.get(id);
        }
        return null;
    }

    private void handleTsFilePipeData(TsFilePipeData tsFilePipeData, String fileDir) {
        File dir = new File(fileDir);
        String tsFileName = tsFilePipeData.getTsFileName();
        File[] targetFiles = dir.listFiles((dir1, name) -> name.startsWith(tsFileName) && name.endsWith(PATCH_SUFFIX));
        if (targetFiles != null) {
            for (File targetFile : targetFiles) {
                File newFile = new File(dir, targetFile.getName().substring(0, targetFile.getName().length() - PATCH_SUFFIX.length()));
                if (targetFile.renameTo(newFile)) continue;
                LOGGER.error("Fail to rename file {} to {}", (Object)targetFile, (Object)newFile);
            }
        }
        tsFilePipeData.setParentDirPath(dir.getAbsolutePath());
    }

    public TSStatus transportFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        SyncIdentityInfo identityInfo = this.getCurrentSyncIdentityInfo();
        if (identityInfo == null) {
            throw new TException("Thrift connection is not alive.");
        }
        LOGGER.debug("Invoke transportData method from client ip = {}", (Object)identityInfo.getRemoteAddress());
        String fileDir = IoTDBLegacyPipeReceiverAgent.getFileDataDir(identityInfo);
        String fileName = metaInfo.fileName;
        long startIndex = metaInfo.startIndex;
        File file = new File(fileDir, fileName + PATCH_SUFFIX);
        IndexCheckResult result = this.checkStartIndexValid(new File(fileDir, fileName), startIndex);
        if (!result.isResult()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_REDIRECTION_ERROR, (String)result.getIndex());
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            int length = buff.remaining();
            randomAccessFile.seek(startIndex);
            byte[] byteArray = new byte[length];
            buff.get(byteArray);
            randomAccessFile.write(byteArray);
            this.recordStartIndex(new File(fileDir, fileName), startIndex + (long)length);
            LOGGER.debug("Sync {} start at {} to {} is done.", new Object[]{fileName, startIndex, startIndex + (long)length});
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private IndexCheckResult checkStartIndexValid(File file, long startIndex) {
        long localIndex = this.getCurrentFileStartIndex(file.getAbsolutePath());
        if (localIndex < 0L && file.exists()) {
            localIndex = file.length();
            this.recordStartIndex(file, localIndex);
        }
        if (localIndex < 0L && startIndex != 0L) {
            LOGGER.error("The start index {} of data sync is not valid. The file is not exist and start index should equal to 0).", (Object)startIndex);
            return new IndexCheckResult(false, "0");
        }
        if (localIndex >= 0L && localIndex != startIndex) {
            LOGGER.error("The start index {} of data sync is not valid. The start index of the file should equal to {}.", (Object)startIndex, (Object)localIndex);
            return new IndexCheckResult(false, String.valueOf(localIndex));
        }
        return new IndexCheckResult(true, "0");
    }

    private long getCurrentFileStartIndex(String absolutePath) {
        Map<String, Long> map;
        Long id = this.currentConnectionId.get();
        if (id != null && (map = this.connectionIdToStartIndexRecord.get(id)) != null && map.containsKey(absolutePath)) {
            return map.get(absolutePath);
        }
        return -1L;
    }

    private void recordStartIndex(File file, long position) {
        Long id = this.currentConnectionId.get();
        if (id != null) {
            Map map = this.connectionIdToStartIndexRecord.computeIfAbsent(id, i -> new ConcurrentHashMap());
            map.put(file.getAbsolutePath(), position);
        }
    }

    private static String getFileDataDir(SyncIdentityInfo identityInfo) {
        return IoTDBLegacyPipeReceiverAgent.getReceiverPipeDir(identityInfo.getPipeName(), identityInfo.getRemoteAddress(), identityInfo.getCreateTime()) + File.separator + FILE_DATA_DIR_NAME;
    }

    private static String getReceiverPipeDir(String pipeName, String remoteIp, long createTime) {
        return IoTDBLegacyPipeReceiverAgent.getReceiverDir() + File.separator + String.format("%s-%d-%s", pipeName, createTime, remoteIp);
    }

    private static String getReceiverDir() {
        return CommonDescriptor.getInstance().getConfig().getSyncDir() + File.separator + RECEIVER_DIR_NAME;
    }

    private static class SyncIdentityInfo {
        private final String pipeName;
        private final long createTime;
        private final String version;
        private final String database;
        private final String remoteAddress;

        public SyncIdentityInfo(TSyncIdentityInfo identityInfo, String remoteAddress) {
            this.pipeName = identityInfo.getPipeName();
            this.createTime = identityInfo.getCreateTime();
            this.version = identityInfo.getVersion();
            this.database = identityInfo.getDatabase();
            this.remoteAddress = remoteAddress;
        }

        public String getPipeName() {
            return this.pipeName;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public String getDatabase() {
            return this.database;
        }
    }

    private static class IndexCheckResult {
        private final boolean result;
        private final String index;

        public IndexCheckResult(boolean result, String index) {
            this.result = result;
            this.index = index;
        }

        public boolean isResult() {
            return this.result;
        }

        public String getIndex() {
            return this.index;
        }
    }
}

