/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package migrationscripts

import (
	"github.com/apache/incubator-devlake/core/context"
	"github.com/apache/incubator-devlake/core/errors"
	"github.com/apache/incubator-devlake/core/models/migrationscripts/archived"
	"github.com/apache/incubator-devlake/helpers/migrationhelper"
)

type addIssueAssignee20230402 struct {
	IssueId      string `gorm:"primaryKey;type:varchar(255)"`
	AssigneeId   string `gorm:"primaryKey;type:varchar(255)"`
	AssigneeName string `gorm:"type:varchar(255)"`

	archived.NoPKModel
}

func (*addIssueAssignee20230402) TableName() string {
	return "issue_assignees"
}

func (u *addIssueAssignee20230402) Up(basicRes context.BasicRes) errors.Error {
	return migrationhelper.AutoMigrateTables(
		basicRes,
		&addIssueAssignee20230402{},
	)
}

func (*addIssueAssignee20230402) Version() uint64 {
	return 20230402000041
}

func (*addIssueAssignee20230402) Name() string {
	return "add issue_assignees table"
}
