/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.openstreetmap;

import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Block;
import org.apache.baremaps.openstreetmap.model.DataBlock;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.HeaderBlock;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.stream.StreamException;
import org.apache.baremaps.postgres.openstreetmap.Repository;

public class BlockImporter
implements Consumer<Block> {
    private final Repository<Long, Header> headerRepository;
    private final Repository<Long, Node> nodeRepository;
    private final Repository<Long, Way> wayRepository;
    private final Repository<Long, Relation> relationRepository;

    public BlockImporter(Repository<Long, Header> headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository) {
        this.headerRepository = headerRepository;
        this.nodeRepository = nodeRepository;
        this.wayRepository = wayRepository;
        this.relationRepository = relationRepository;
    }

    @Override
    public void accept(Block block) {
        try {
            if (block instanceof HeaderBlock) {
                HeaderBlock headerBlock = (HeaderBlock)block;
                this.headerRepository.put(headerBlock.getHeader());
            } else if (block instanceof DataBlock) {
                DataBlock dataBlock = (DataBlock)block;
                this.nodeRepository.copy(dataBlock.getDenseNodes());
                this.nodeRepository.copy(dataBlock.getNodes());
                this.wayRepository.copy(dataBlock.getWays());
                this.relationRepository.copy(dataBlock.getRelations());
            }
        }
        catch (Exception e) {
            throw new StreamException((Throwable)e);
        }
    }
}

