/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.metadata.sql.util.SQLUtilities;
import org.apache.sis.metadata.sql.util.ScriptRunner;
import org.apache.sis.referencing.factory.sql.InstallationScriptProvider;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.system.Fallback;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Messages;

final class EPSGInstaller
extends ScriptRunner {
    static final String REPLACE_STATEMENT = "UPDATE\\s+[\\w\\.\" ]+\\s+SET\\s+(\\w+)\\s*=\\s*replace\\s*\\(\\s*\\1\\W+.*";
    private final boolean replacePilcrow;

    public EPSGInstaller(Connection connection) throws SQLException {
        super(connection, 100);
        boolean isReplaceSupported = false;
        DatabaseMetaData metadata = connection.getMetaData();
        String functions = metadata.getStringFunctions();
        StringTokenizer tk = new StringTokenizer(functions, ",");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken().trim();
            if (!token.equalsIgnoreCase("REPLACE")) continue;
            isReplaceSupported = true;
            break;
        }
        if (!isReplaceSupported) {
            this.addStatementToSkip(REPLACE_STATEMENT);
        }
        this.addStatementToSkip("COMMIT");
        this.replacePilcrow = false;
    }

    public void setSchema(String schema) throws SQLException, IOException {
        if (this.isSchemaSupported) {
            this.execute(new StringBuilder("CREATE SCHEMA ").append(this.identifierQuote).append(schema).append(this.identifierQuote));
            if (this.isGrantOnSchemaSupported) {
                this.execute(new StringBuilder("GRANT USAGE ON SCHEMA ").append(this.identifierQuote).append(schema).append(this.identifierQuote).append(" TO ").append("PUBLIC"));
            }
            this.addReplacement("epsg_alias", "Alias");
            this.addReplacement("epsg_area", "Area");
            this.addReplacement("epsg_change", "Change");
            this.addReplacement("epsg_coordinateaxis", "Coordinate Axis");
            this.addReplacement("epsg_coordinateaxisname", "Coordinate Axis Name");
            this.addReplacement("epsg_coordoperation", "Coordinate_Operation");
            this.addReplacement("epsg_coordoperationmethod", "Coordinate_Operation Method");
            this.addReplacement("epsg_coordoperationparam", "Coordinate_Operation Parameter");
            this.addReplacement("epsg_coordoperationparamusage", "Coordinate_Operation Parameter Usage");
            this.addReplacement("epsg_coordoperationparamvalue", "Coordinate_Operation Parameter Value");
            this.addReplacement("epsg_coordoperationpath", "Coordinate_Operation Path");
            this.addReplacement("epsg_coordinatereferencesystem", "Coordinate Reference System");
            this.addReplacement("epsg_coordinatesystem", "Coordinate System");
            this.addReplacement("epsg_datum", "Datum");
            this.addReplacement("epsg_deprecation", "Deprecation");
            this.addReplacement("epsg_ellipsoid", "Ellipsoid");
            this.addReplacement("epsg_namingsystem", "Naming System");
            this.addReplacement("epsg_primemeridian", "Prime Meridian");
            this.addReplacement("epsg_supersession", "Supersession");
            this.addReplacement("epsg_unitofmeasure", "Unit of Measure");
            this.addReplacement("epsg_versionhistory", "Version History");
            if (this.isEnumTypeSupported) {
                this.addReplacement("epsg_datum_kind", "Datum Kind");
                this.addReplacement("epsg_crs_kind", "CRS Kind");
                this.addReplacement("epsg_cs_kind", "CS Kind");
                this.addReplacement("epsg_table_name", "Table Name");
            }
            this.prependNamespace(schema);
        }
        if (!this.isEnumTypeSupported) {
            this.addReplacement("epsg_datum_kind", "VARCHAR(80)");
            this.addReplacement("epsg_crs_kind", "VARCHAR(80)");
            this.addReplacement("epsg_cs_kind", "VARCHAR(80)");
            this.addReplacement("epsg_table_name", "VARCHAR(80)");
        }
    }

    final void prependNamespace(String schema) {
        this.modifyReplacements((key, value) -> {
            if (key.startsWith("epsg_")) {
                StringBuilder buffer = new StringBuilder(value.length() + schema.length() + 5);
                buffer.append(this.identifierQuote).append(schema).append(this.identifierQuote).append('.');
                boolean isQuoted = value.endsWith(this.identifierQuote);
                if (!isQuoted) {
                    buffer.append(this.identifierQuote);
                }
                buffer.append((String)value);
                if (!isQuoted) {
                    buffer.append(this.identifierQuote);
                }
                value = buffer.toString();
            }
            return value;
        });
    }

    protected void editText(StringBuilder sql, int lower, int upper) {
        switch (upper - lower) {
            default: {
                return;
            }
            case 2: 
        }
        String replacement = "Null";
        sql.replace(lower, upper, replacement);
    }

    protected int execute(StringBuilder sql) throws SQLException, IOException {
        if (this.replacePilcrow) {
            StringBuilders.replace((StringBuilder)sql, (String)"\u00b6", (String)"\n");
        }
        return super.execute(sql);
    }

    public void run(InstallationResources scriptProvider, Locale locale) throws SQLException, IOException {
        long time = System.nanoTime();
        InstallationScriptProvider.log(Messages.getResources((Locale)locale).getLogRecord(Level.INFO, (short)11, (Object)"EPSG", (Object)SQLUtilities.getSimplifiedURL((DatabaseMetaData)this.getConnection().getMetaData())));
        if (scriptProvider == null) {
            scriptProvider = EPSGInstaller.lookupProvider(locale);
        }
        String[] scripts = scriptProvider.getResourceNames("EPSG");
        int numRows = 0;
        for (int i = 0; i < scripts.length; ++i) {
            try (BufferedReader in = scriptProvider.openScript("EPSG", i);){
                numRows += this.run(scripts[i], in);
                continue;
            }
        }
        time = System.nanoTime() - time;
        InstallationScriptProvider.log(Messages.getResources((Locale)locale).getLogRecord(PerformanceLevel.forDuration((long)time, (TimeUnit)TimeUnit.NANOSECONDS), (short)23, (Object)numRows, (Object)Float.valueOf((float)time / 1.0E9f)));
    }

    private static InstallationResources lookupProvider(Locale locale) throws IOException {
        InstallationResources fallback = null;
        for (InstallationResources provider : InstallationResources.load()) {
            if (!provider.getAuthorities().contains("EPSG")) continue;
            if (!provider.getClass().isAnnotationPresent(Fallback.class)) {
                return provider;
            }
            fallback = provider;
        }
        InstallationScriptProvider.Default manual = new InstallationScriptProvider.Default(locale);
        if (fallback != null && manual.getAuthorities().isEmpty()) {
            return fallback;
        }
        return manual;
    }

    final String failure(Locale locale, Exception cause) {
        Object message = Messages.getResources((Locale)locale).getString((short)2, (Object)"EPSG");
        String status = this.status(locale);
        if (status != null) {
            message = (String)message + " " + status;
        }
        return Exceptions.formatChainedMessages((Locale)locale, (String)message, (Throwable)cause);
    }
}

