/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.sis.util.internal.Strings;

final class DimensionSelector
implements Comparable<DimensionSelector> {
    final int dimension;
    private final long[] positions;
    private BigInteger sumOfSize;
    private double relativeIncrement;
    private long incrementRange;
    boolean isConstantPosition;

    DimensionSelector(int dim, int n) {
        this.dimension = dim;
        this.positions = new long[n];
        this.sumOfSize = BigInteger.ZERO;
    }

    final void setSliceExtent(int i, long pos, long size) {
        this.positions[i] = pos;
        this.sumOfSize = this.sumOfSize.add(BigInteger.valueOf(size));
    }

    final void finish() {
        Arrays.sort(this.positions);
        long maxInc = 0L;
        long minInc = Long.MAX_VALUE;
        BigInteger sumOfInc = BigInteger.ZERO;
        long previous = this.positions[0];
        for (int i = 1; i < this.positions.length; ++i) {
            long p = this.positions[i];
            long d = p - previous;
            if (d == 0L) continue;
            if (d < minInc) {
                minInc = d;
            }
            if (d > maxInc) {
                maxInc = d;
            }
            sumOfInc = sumOfInc.add(BigInteger.valueOf(d));
            previous = p;
        }
        boolean bl = this.isConstantPosition = maxInc == 0L;
        if (minInc <= maxInc) {
            this.relativeIncrement = sumOfInc.doubleValue() / this.sumOfSize.doubleValue();
            this.incrementRange = maxInc - minInc;
        }
    }

    @Override
    public int compareTo(DimensionSelector other) {
        int c = Boolean.compare(other.isConstantPosition, this.isConstantPosition);
        if (c == 0 && (c = Double.compare(this.relativeIncrement, other.relativeIncrement)) == 0) {
            c = Long.compare(other.incrementRange, this.incrementRange);
        }
        return c;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"dimension", this.dimension, "relativeIncrement", this.relativeIncrement});
    }
}

