/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.rpsl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.baremaps.rpsl.RpslDataRowIterator;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataColumnFixed;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataSchemaImpl;
import org.apache.baremaps.store.DataTable;

public class RpslDataTable
implements DataTable {
    private final DataSchema schema;
    private final InputStream inputStream;

    public RpslDataTable(InputStream inputStream) {
        this.inputStream = inputStream;
        this.schema = this.createSchema();
    }

    private DataSchema createSchema() {
        ArrayList<DataColumnFixed> columns = new ArrayList<DataColumnFixed>();
        columns.add(new DataColumnFixed("type", DataColumn.Cardinality.REQUIRED, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("id", DataColumn.Cardinality.REQUIRED, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("inetnum", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("inet6num", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("netname", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("descr", DataColumn.Cardinality.REPEATED, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("country", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("admin-c", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("tech-c", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("status", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("mnt-by", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("created", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("last-modified", DataColumn.Cardinality.OPTIONAL, DataColumn.Type.STRING));
        columns.add(new DataColumnFixed("changed", DataColumn.Cardinality.REPEATED, DataColumn.Type.STRING));
        return new DataSchemaImpl("RpslObject", columns);
    }

    public DataSchema schema() {
        return this.schema;
    }

    public long size() {
        return -1L;
    }

    public Iterator<DataRow> iterator() {
        return new RpslDataRowIterator(this.inputStream, this.schema);
    }

    public void clear() {
        throw new UnsupportedOperationException("Clear operation is not supported.");
    }
}

