/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.WriteOperations;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.impl.PutObjectOptions;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.fs.store.audit.AuditingFunctions;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class WriteOperationHelper
implements WriteOperations {
    private static final Logger LOG = LoggerFactory.getLogger(WriteOperationHelper.class);
    private final S3AFileSystem owner;
    private final Invoker invoker;
    private final Configuration conf;
    private final String bucket;
    private final S3AStatisticsContext statisticsContext;
    private final StoreContext storeContext;
    private final AuditSpanSource auditSpanSource;
    private AuditSpan auditSpan;
    private final RequestFactory requestFactory;
    private final WriteOperationHelperCallbacks writeOperationHelperCallbacks;

    protected WriteOperationHelper(S3AFileSystem owner, Configuration conf, S3AStatisticsContext statisticsContext, AuditSpanSource auditSpanSource, AuditSpan auditSpan, WriteOperationHelperCallbacks writeOperationHelperCallbacks) {
        this.owner = owner;
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
        this.conf = conf;
        this.statisticsContext = statisticsContext;
        this.storeContext = owner.createStoreContext();
        this.bucket = owner.getBucket();
        this.auditSpanSource = auditSpanSource;
        this.auditSpan = (AuditSpan)Preconditions.checkNotNull((Object)auditSpan);
        this.requestFactory = owner.getRequestFactory();
        this.writeOperationHelperCallbacks = writeOperationHelperCallbacks;
    }

    void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        LOG.info("{}: Retried {}: {}", new Object[]{text, retries, ex.toString()});
        LOG.debug("Stack", (Throwable)ex);
        this.owner.operationRetried(text, ex, retries, idempotent);
    }

    @Override
    public <T> T retry(String action, String path, boolean idempotent, CallableRaisingIOE<T> operation) throws IOException {
        this.activateAuditSpan();
        return this.invoker.retry(action, path, idempotent, operation);
    }

    public AuditSpan getAuditSpan() {
        return this.auditSpan;
    }

    private AuditSpan activateAuditSpan() {
        return this.auditSpan.activate();
    }

    private void deactivateAuditSpan() {
        this.auditSpan.deactivate();
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String destKey, long length, PutObjectOptions options, boolean isFile) {
        this.activateAuditSpan();
        return (PutObjectRequest)this.getRequestFactory().newPutObjectRequestBuilder(destKey, options, length, false).build();
    }

    @Override
    public void writeSuccessful(long length) {
    }

    @Override
    public void writeFailed(Exception ex) {
        LOG.debug("Write to {} failed", (Object)this, (Object)ex);
    }

    @Override
    public String initiateMultiPartUpload(String destKey, PutObjectOptions options) throws IOException {
        LOG.debug("Initiating Multipart upload to {}", (Object)destKey);
        try (AuditSpan span = this.activateAuditSpan();){
            String string = (String)this.retry("initiate MultiPartUpload", destKey, true, () -> {
                CreateMultipartUploadRequest.Builder initiateMPURequestBuilder = this.getRequestFactory().newMultipartUploadRequestBuilder(destKey, options);
                return this.owner.initiateMultipartUpload((CreateMultipartUploadRequest)initiateMPURequestBuilder.build()).uploadId();
            });
            return string;
        }
    }

    private CompleteMultipartUploadResponse finalizeMultipartUpload(String destKey, String uploadId, List<CompletedPart> partETags, long length, PutObjectOptions putOptions, Invoker.Retried retrying) throws IOException {
        if (partETags.isEmpty()) {
            throw new PathIOException(destKey, "No upload parts in multipart upload");
        }
        try (AuditSpan span = this.activateAuditSpan();){
            CompleteMultipartUploadResponse uploadResult = (CompleteMultipartUploadResponse)this.invoker.retry("Completing multipart upload", destKey, true, retrying, () -> {
                CompleteMultipartUploadRequest.Builder requestBuilder = this.getRequestFactory().newCompleteMultipartUploadRequestBuilder(destKey, uploadId, partETags);
                return this.writeOperationHelperCallbacks.completeMultipartUpload((CompleteMultipartUploadRequest)requestBuilder.build());
            });
            this.owner.finishedWrite(destKey, length, uploadResult.eTag(), uploadResult.versionId(), putOptions);
            CompleteMultipartUploadResponse completeMultipartUploadResponse = uploadResult;
            return completeMultipartUploadResponse;
        }
    }

    @Override
    public CompleteMultipartUploadResponse completeMPUwithRetries(String destKey, String uploadId, List<CompletedPart> partETags, long length, AtomicInteger errorCount, PutObjectOptions putOptions) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, putOptions, (text, e, r, i) -> errorCount.incrementAndGet());
    }

    @Override
    public void abortMultipartUpload(String destKey, String uploadId, boolean shouldRetry, Invoker.Retried retrying) throws IOException {
        if (shouldRetry) {
            this.invoker.retry("Aborting multipart upload ID " + uploadId, destKey, true, retrying, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.abortMultipartUpload(destKey, uploadId)));
        } else {
            Invoker.once("Aborting multipart upload ID " + uploadId, destKey, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.abortMultipartUpload(destKey, uploadId)));
        }
    }

    @Override
    public void abortMultipartUpload(MultipartUpload upload) throws IOException {
        this.invoker.retry("Aborting multipart commit", upload.key(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.abortMultipartUpload(upload)));
    }

    @Override
    public int abortMultipartUploadsUnderPath(String prefix) throws IOException {
        LOG.debug("Aborting multipart uploads under {}", (Object)prefix);
        int count = 0;
        List<MultipartUpload> multipartUploads = this.listMultipartUploads(prefix);
        LOG.debug("Number of outstanding uploads: {}", (Object)multipartUploads.size());
        for (MultipartUpload upload : multipartUploads) {
            try {
                this.abortMultipartUpload(upload);
                ++count;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Already aborted: {}", (Object)upload.key(), (Object)e);
            }
        }
        return count;
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        this.activateAuditSpan();
        return this.owner.listMultipartUploads(prefix);
    }

    @Override
    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        this.abortMultipartUpload(destKey, uploadId, true, this.invoker.getRetryCallback());
    }

    @Override
    public UploadPartRequest.Builder newUploadPartRequestBuilder(String destKey, String uploadId, int partNumber, long size) throws IOException {
        return (UploadPartRequest.Builder)Invoker.once("upload part request", destKey, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.getRequestFactory().newUploadPartRequestBuilder(destKey, uploadId, partNumber, size)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOperationHelper {bucket=").append(this.bucket);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, PutObjectOptions putOptions, S3ADataBlocks.BlockUploadData uploadData, boolean isFile, DurationTrackerFactory durationTrackerFactory) throws IOException {
        return (PutObjectResponse)this.retry("Writing Object", putObjectRequest.key(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.putObjectDirect(putObjectRequest, putOptions, uploadData, isFile, durationTrackerFactory)));
    }

    @Override
    public void revertCommit(String destKey) throws IOException {
        Invoker.once("revert commit", destKey, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            Path destPath = this.owner.keyToQualifiedPath(destKey);
            this.owner.deleteObjectAtPath(destPath, destKey, true);
        }));
    }

    @Override
    public CompleteMultipartUploadResponse commitUpload(String destKey, String uploadId, List<CompletedPart> partETags, long length) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, PutObjectOptions.keepingDirs(), Invoker.NO_OP);
    }

    @Override
    public UploadPartResponse uploadPart(UploadPartRequest request, RequestBody body, DurationTrackerFactory durationTrackerFactory) throws IOException {
        return (UploadPartResponse)this.retry("upload part #" + request.partNumber() + " upload ID " + request.uploadId(), request.key(), true, AuditingFunctions.withinAuditSpan((AuditSpan)this.getAuditSpan(), () -> this.owner.uploadPart(request, body, durationTrackerFactory)));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public AuditSpan createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return this.auditSpanSource.createSpan(operation, path1, path2);
    }

    @Override
    public void incrementWriteOperations() {
        this.owner.incrementWriteOperations();
    }

    @Override
    public void close() throws IOException {
        this.deactivateAuditSpan();
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public static interface WriteOperationHelperCallbacks {
        public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest var1);
    }
}

