/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.management;

import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.stream.Collectors;

enum ThreadDumpService implements HttpService
{
    INSTANCE;


    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        boolean acceptJson = req.headers().accept().stream().anyMatch(MediaType.JSON::is);
        ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        if (acceptJson) {
            return HttpResponse.ofJson(threadInfos);
        }
        String threadDump = Arrays.stream(threadInfos).map(ThreadInfo::toString).collect(Collectors.joining());
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT, threadDump);
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.UNARY;
    }
}

