/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateArrayDataType
implements DataType<Coordinate[]> {
    @Override
    public int size(Coordinate[] value) {
        return 4 + 16 * value.length;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Coordinate[] value) {
        buffer.putInt(position, this.size(value));
        int p = position + 4;
        for (int i = 0; i < value.length; ++i) {
            Coordinate coordinate = value[i];
            buffer.putDouble(p, coordinate.x);
            buffer.putDouble(p += 8, coordinate.y);
            p += 8;
        }
    }

    @Override
    public Coordinate[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int numPoints = (size - 4) / 16;
        int p = position + 4;
        Coordinate[] coordinates = new Coordinate[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            double x = buffer.getDouble(p);
            double y = buffer.getDouble(p + 8);
            coordinates[i] = new Coordinate(x, y);
            p += 16;
        }
        return coordinates;
    }
}

