package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.GeospatialData;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileMatrixLimits;
import org.apache.baremaps.ogcapi.model.TileSetBoundingBox;
import org.apache.baremaps.ogcapi.model.TileSetCenterPoint;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import org.apache.baremaps.ogcapi.model.TileSetDataType;
import org.apache.baremaps.ogcapi.model.TileSetStyle;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A resource describing a tileSet based on the OGC TileSet Metadata Standard. At least one of the &#39;TileMatrixSet&#39;,  or a link with &#39;rel&#39; http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme
 **/
@ApiModel(description = "A resource describing a tileSet based on the OGC TileSet Metadata Standard. At least one of the 'TileMatrixSet',  or a link with 'rel' http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme")
@JsonTypeName("tileSet")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TileSet   {
  private @Valid String title;
  private @Valid String description;
  private @Valid TileSetDataType dataType;
  private @Valid TileSetCrs crs;
  private @Valid URI tileMatrixSetURI;
  private @Valid List<Link> links = new ArrayList<>();
  private @Valid List<TileMatrixLimits> tileMatrixSetLimits = null;
  private @Valid BigDecimal epoch;
  private @Valid List<GeospatialData> layers = null;
  private @Valid TileSetBoundingBox boundingBox;
  private @Valid TileSetCenterPoint centerPoint;
  private @Valid TileSetStyle style;
  private @Valid String attribution;
  private @Valid String license;
  public enum AccessConstraintsEnum {

    UNCLASSIFIED(String.valueOf("unclassified")), RESTRICTED(String.valueOf("restricted")), CONFIDENTIAL(String.valueOf("confidential")), SECRET(String.valueOf("secret")), TOPSECRET(String.valueOf("topSecret"));


    private String value;

    AccessConstraintsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static AccessConstraintsEnum fromString(String s) {
        for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static AccessConstraintsEnum fromValue(String value) {
        for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid AccessConstraintsEnum accessConstraints = AccessConstraintsEnum.UNCLASSIFIED;
  private @Valid List<String> keywords = null;
  private @Valid String version;
  private @Valid Object created;
  private @Valid Object updated;
  private @Valid String pointOfContact;
  private @Valid List<String> mediaTypes = null;

  /**
   * A title for this tileSet
   **/
  public TileSet title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "A title for this tileSet")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Brief narrative description of this tile set
   **/
  public TileSet description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "Brief narrative description of this tile set")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public TileSet dataType(TileSetDataType dataType) {
    this.dataType = dataType;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("dataType")
  @NotNull
  public TileSetDataType getDataType() {
    return dataType;
  }

  @JsonProperty("dataType")
  public void setDataType(TileSetDataType dataType) {
    this.dataType = dataType;
  }

  /**
   **/
  public TileSet crs(TileSetCrs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("crs")
  @NotNull
  public TileSetCrs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(TileSetCrs crs) {
    this.crs = crs;
  }

  /**
   * Reference to a Tile Matrix Set on an offical source for Tile Matrix Sets such as the OGC NA definition server (http://www.opengis.net/def/tms/). Required if the tile matrix set is registered on an open official source.
   **/
  public TileSet tileMatrixSetURI(URI tileMatrixSetURI) {
    this.tileMatrixSetURI = tileMatrixSetURI;
    return this;
  }

  
  @ApiModelProperty(value = "Reference to a Tile Matrix Set on an offical source for Tile Matrix Sets such as the OGC NA definition server (http://www.opengis.net/def/tms/). Required if the tile matrix set is registered on an open official source.")
  @JsonProperty("tileMatrixSetURI")
  public URI getTileMatrixSetURI() {
    return tileMatrixSetURI;
  }

  @JsonProperty("tileMatrixSetURI")
  public void setTileMatrixSetURI(URI tileMatrixSetURI) {
    this.tileMatrixSetURI = tileMatrixSetURI;
  }

  /**
   * Links to related resources. Possible link &#39;rel&#39; values are: &#39;http://www.opengis.net/def/rel/ogc/1.0/dataset&#39; for a URL pointing to the dataset, &#39;item&#39; for a URL template to get a tile; &#39;alternate&#39; for a URL pointing to another representation of the TileSetMetadata (e.g a TileJSON file); &#39;http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme&#39; for a definition of the TileMatrixSet; &#39;http://www.opengis.net/def/rel/ogc/1.0/geodata&#39; for pointing to a single collection (if the tileSet represents a single collection)
   **/
  public TileSet links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Links to related resources. Possible link 'rel' values are: 'http://www.opengis.net/def/rel/ogc/1.0/dataset' for a URL pointing to the dataset, 'item' for a URL template to get a tile; 'alternate' for a URL pointing to another representation of the TileSetMetadata (e.g a TileJSON file); 'http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme' for a definition of the TileMatrixSet; 'http://www.opengis.net/def/rel/ogc/1.0/geodata' for pointing to a single collection (if the tileSet represents a single collection)")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public TileSet addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public TileSet removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }
  /**
   * Limits for the TileRow and TileCol values for each TileMatrix in the tileMatrixSet. If missing, there are no limits other that the ones imposed by the TileMatrixSet. If present the TileMatrices listed are limited and the rest not available at all
   **/
  public TileSet tileMatrixSetLimits(List<TileMatrixLimits> tileMatrixSetLimits) {
    this.tileMatrixSetLimits = tileMatrixSetLimits;
    return this;
  }

  
  @ApiModelProperty(value = "Limits for the TileRow and TileCol values for each TileMatrix in the tileMatrixSet. If missing, there are no limits other that the ones imposed by the TileMatrixSet. If present the TileMatrices listed are limited and the rest not available at all")
  @JsonProperty("tileMatrixSetLimits")
  public List<TileMatrixLimits> getTileMatrixSetLimits() {
    return tileMatrixSetLimits;
  }

  @JsonProperty("tileMatrixSetLimits")
  public void setTileMatrixSetLimits(List<TileMatrixLimits> tileMatrixSetLimits) {
    this.tileMatrixSetLimits = tileMatrixSetLimits;
  }

  public TileSet addTileMatrixSetLimitsItem(TileMatrixLimits tileMatrixSetLimitsItem) {
    if (this.tileMatrixSetLimits == null) {
      this.tileMatrixSetLimits = new ArrayList<>();
    }

    this.tileMatrixSetLimits.add(tileMatrixSetLimitsItem);
    return this;
  }

  public TileSet removeTileMatrixSetLimitsItem(TileMatrixLimits tileMatrixSetLimitsItem) {
    if (tileMatrixSetLimitsItem != null && this.tileMatrixSetLimits != null) {
      this.tileMatrixSetLimits.remove(tileMatrixSetLimitsItem);
    }

    return this;
  }
  /**
   * Epoch of the Coordinate Reference System (CRS)
   **/
  public TileSet epoch(BigDecimal epoch) {
    this.epoch = epoch;
    return this;
  }

  
  @ApiModelProperty(value = "Epoch of the Coordinate Reference System (CRS)")
  @JsonProperty("epoch")
  public BigDecimal getEpoch() {
    return epoch;
  }

  @JsonProperty("epoch")
  public void setEpoch(BigDecimal epoch) {
    this.epoch = epoch;
  }

  /**
   **/
  public TileSet layers(List<GeospatialData> layers) {
    this.layers = layers;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("layers")
 @Size(min=1)  public List<GeospatialData> getLayers() {
    return layers;
  }

  @JsonProperty("layers")
  public void setLayers(List<GeospatialData> layers) {
    this.layers = layers;
  }

  public TileSet addLayersItem(GeospatialData layersItem) {
    if (this.layers == null) {
      this.layers = new ArrayList<>();
    }

    this.layers.add(layersItem);
    return this;
  }

  public TileSet removeLayersItem(GeospatialData layersItem) {
    if (layersItem != null && this.layers != null) {
      this.layers.remove(layersItem);
    }

    return this;
  }
  /**
   **/
  public TileSet boundingBox(TileSetBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("boundingBox")
  public TileSetBoundingBox getBoundingBox() {
    return boundingBox;
  }

  @JsonProperty("boundingBox")
  public void setBoundingBox(TileSetBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
  }

  /**
   **/
  public TileSet centerPoint(TileSetCenterPoint centerPoint) {
    this.centerPoint = centerPoint;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("centerPoint")
  public TileSetCenterPoint getCenterPoint() {
    return centerPoint;
  }

  @JsonProperty("centerPoint")
  public void setCenterPoint(TileSetCenterPoint centerPoint) {
    this.centerPoint = centerPoint;
  }

  /**
   **/
  public TileSet style(TileSetStyle style) {
    this.style = style;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("style")
  public TileSetStyle getStyle() {
    return style;
  }

  @JsonProperty("style")
  public void setStyle(TileSetStyle style) {
    this.style = style;
  }

  /**
   * Short reference to recognize the author or provider
   **/
  public TileSet attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  
  @ApiModelProperty(value = "Short reference to recognize the author or provider")
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  @JsonProperty("attribution")
  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  /**
   * License applicable to the tiles
   **/
  public TileSet license(String license) {
    this.license = license;
    return this;
  }

  
  @ApiModelProperty(value = "License applicable to the tiles")
  @JsonProperty("license")
  public String getLicense() {
    return license;
  }

  @JsonProperty("license")
  public void setLicense(String license) {
    this.license = license;
  }

  /**
   * Restrictions on the availability of the Tile Set that the user needs to be aware of before using or redistributing the Tile Set
   **/
  public TileSet accessConstraints(AccessConstraintsEnum accessConstraints) {
    this.accessConstraints = accessConstraints;
    return this;
  }

  
  @ApiModelProperty(value = "Restrictions on the availability of the Tile Set that the user needs to be aware of before using or redistributing the Tile Set")
  @JsonProperty("accessConstraints")
  public AccessConstraintsEnum getAccessConstraints() {
    return accessConstraints;
  }

  @JsonProperty("accessConstraints")
  public void setAccessConstraints(AccessConstraintsEnum accessConstraints) {
    this.accessConstraints = accessConstraints;
  }

  /**
   * keywords about this tileSet
   **/
  public TileSet keywords(List<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  
  @ApiModelProperty(value = "keywords about this tileSet")
  @JsonProperty("keywords")
  public List<String> getKeywords() {
    return keywords;
  }

  @JsonProperty("keywords")
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  public TileSet addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }

    this.keywords.add(keywordsItem);
    return this;
  }

  public TileSet removeKeywordsItem(String keywordsItem) {
    if (keywordsItem != null && this.keywords != null) {
      this.keywords.remove(keywordsItem);
    }

    return this;
  }
  /**
   * Version of the Tile Set. Changes if the data behind the tiles has been changed
   **/
  public TileSet version(String version) {
    this.version = version;
    return this;
  }

  
  @ApiModelProperty(value = "Version of the Tile Set. Changes if the data behind the tiles has been changed")
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  @JsonProperty("version")
  public void setVersion(String version) {
    this.version = version;
  }

  /**
   **/
  public TileSet created(Object created) {
    this.created = created;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created")
  public Object getCreated() {
    return created;
  }

  @JsonProperty("created")
  public void setCreated(Object created) {
    this.created = created;
  }

  /**
   **/
  public TileSet updated(Object updated) {
    this.updated = updated;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated")
  public Object getUpdated() {
    return updated;
  }

  @JsonProperty("updated")
  public void setUpdated(Object updated) {
    this.updated = updated;
  }

  /**
   * Useful information to contact the authors or custodians for the Tile Set
   **/
  public TileSet pointOfContact(String pointOfContact) {
    this.pointOfContact = pointOfContact;
    return this;
  }

  
  @ApiModelProperty(value = "Useful information to contact the authors or custodians for the Tile Set")
  @JsonProperty("pointOfContact")
  public String getPointOfContact() {
    return pointOfContact;
  }

  @JsonProperty("pointOfContact")
  public void setPointOfContact(String pointOfContact) {
    this.pointOfContact = pointOfContact;
  }

  /**
   * Media types available for the tiles
   **/
  public TileSet mediaTypes(List<String> mediaTypes) {
    this.mediaTypes = mediaTypes;
    return this;
  }

  
  @ApiModelProperty(value = "Media types available for the tiles")
  @JsonProperty("mediaTypes")
  public List<String> getMediaTypes() {
    return mediaTypes;
  }

  @JsonProperty("mediaTypes")
  public void setMediaTypes(List<String> mediaTypes) {
    this.mediaTypes = mediaTypes;
  }

  public TileSet addMediaTypesItem(String mediaTypesItem) {
    if (this.mediaTypes == null) {
      this.mediaTypes = new ArrayList<>();
    }

    this.mediaTypes.add(mediaTypesItem);
    return this;
  }

  public TileSet removeMediaTypesItem(String mediaTypesItem) {
    if (mediaTypesItem != null && this.mediaTypes != null) {
      this.mediaTypes.remove(mediaTypesItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileSet tileSet = (TileSet) o;
    return Objects.equals(this.title, tileSet.title) &&
        Objects.equals(this.description, tileSet.description) &&
        Objects.equals(this.dataType, tileSet.dataType) &&
        Objects.equals(this.crs, tileSet.crs) &&
        Objects.equals(this.tileMatrixSetURI, tileSet.tileMatrixSetURI) &&
        Objects.equals(this.links, tileSet.links) &&
        Objects.equals(this.tileMatrixSetLimits, tileSet.tileMatrixSetLimits) &&
        Objects.equals(this.epoch, tileSet.epoch) &&
        Objects.equals(this.layers, tileSet.layers) &&
        Objects.equals(this.boundingBox, tileSet.boundingBox) &&
        Objects.equals(this.centerPoint, tileSet.centerPoint) &&
        Objects.equals(this.style, tileSet.style) &&
        Objects.equals(this.attribution, tileSet.attribution) &&
        Objects.equals(this.license, tileSet.license) &&
        Objects.equals(this.accessConstraints, tileSet.accessConstraints) &&
        Objects.equals(this.keywords, tileSet.keywords) &&
        Objects.equals(this.version, tileSet.version) &&
        Objects.equals(this.created, tileSet.created) &&
        Objects.equals(this.updated, tileSet.updated) &&
        Objects.equals(this.pointOfContact, tileSet.pointOfContact) &&
        Objects.equals(this.mediaTypes, tileSet.mediaTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, description, dataType, crs, tileMatrixSetURI, links, tileMatrixSetLimits, epoch, layers, boundingBox, centerPoint, style, attribution, license, accessConstraints, keywords, version, created, updated, pointOfContact, mediaTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileSet {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    tileMatrixSetURI: ").append(toIndentedString(tileMatrixSetURI)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    tileMatrixSetLimits: ").append(toIndentedString(tileMatrixSetLimits)).append("\n");
    sb.append("    epoch: ").append(toIndentedString(epoch)).append("\n");
    sb.append("    layers: ").append(toIndentedString(layers)).append("\n");
    sb.append("    boundingBox: ").append(toIndentedString(boundingBox)).append("\n");
    sb.append("    centerPoint: ").append(toIndentedString(centerPoint)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    license: ").append(toIndentedString(license)).append("\n");
    sb.append("    accessConstraints: ").append(toIndentedString(accessConstraints)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("    pointOfContact: ").append(toIndentedString(pointOfContact)).append("\n");
    sb.append("    mediaTypes: ").append(toIndentedString(mediaTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

