/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="The limits for an individual tile matrix of a TileSet's TileMatrixSet, as defined in the OGC 2D TileMatrixSet and TileSet Metadata Standard")
@JsonTypeName(value="tileMatrixLimits")
public class TileMatrixLimits {
    @Valid
    private String tileMatrix;
    @Valid
    private Integer minTileRow;
    @Valid
    private Integer maxTileRow;
    @Valid
    private Integer minTileCol;
    @Valid
    private Integer maxTileCol;

    public TileMatrixLimits tileMatrix(String tileMatrix) {
        this.tileMatrix = tileMatrix;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="tileMatrix")
    @NotNull
    public String getTileMatrix() {
        return this.tileMatrix;
    }

    @JsonProperty(value="tileMatrix")
    public void setTileMatrix(String tileMatrix) {
        this.tileMatrix = tileMatrix;
    }

    public TileMatrixLimits minTileRow(Integer minTileRow) {
        this.minTileRow = minTileRow;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="minTileRow")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Integer getMinTileRow() {
        return this.minTileRow;
    }

    @JsonProperty(value="minTileRow")
    public void setMinTileRow(Integer minTileRow) {
        this.minTileRow = minTileRow;
    }

    public TileMatrixLimits maxTileRow(Integer maxTileRow) {
        this.maxTileRow = maxTileRow;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="maxTileRow")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Integer getMaxTileRow() {
        return this.maxTileRow;
    }

    @JsonProperty(value="maxTileRow")
    public void setMaxTileRow(Integer maxTileRow) {
        this.maxTileRow = maxTileRow;
    }

    public TileMatrixLimits minTileCol(Integer minTileCol) {
        this.minTileCol = minTileCol;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="minTileCol")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Integer getMinTileCol() {
        return this.minTileCol;
    }

    @JsonProperty(value="minTileCol")
    public void setMinTileCol(Integer minTileCol) {
        this.minTileCol = minTileCol;
    }

    public TileMatrixLimits maxTileCol(Integer maxTileCol) {
        this.maxTileCol = maxTileCol;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="maxTileCol")
    @NotNull
    @Min(value=0L)
    public @NotNull @Min(value=0L) Integer getMaxTileCol() {
        return this.maxTileCol;
    }

    @JsonProperty(value="maxTileCol")
    public void setMaxTileCol(Integer maxTileCol) {
        this.maxTileCol = maxTileCol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileMatrixLimits tileMatrixLimits = (TileMatrixLimits)o;
        return Objects.equals(this.tileMatrix, tileMatrixLimits.tileMatrix) && Objects.equals(this.minTileRow, tileMatrixLimits.minTileRow) && Objects.equals(this.maxTileRow, tileMatrixLimits.maxTileRow) && Objects.equals(this.minTileCol, tileMatrixLimits.minTileCol) && Objects.equals(this.maxTileCol, tileMatrixLimits.maxTileCol);
    }

    public int hashCode() {
        return Objects.hash(this.tileMatrix, this.minTileRow, this.maxTileRow, this.minTileCol, this.maxTileCol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileMatrixLimits {\n");
        sb.append("    tileMatrix: ").append(this.toIndentedString(this.tileMatrix)).append("\n");
        sb.append("    minTileRow: ").append(this.toIndentedString(this.minTileRow)).append("\n");
        sb.append("    maxTileRow: ").append(this.toIndentedString(this.maxTileRow)).append("\n");
        sb.append("    minTileCol: ").append(this.toIndentedString(this.minTileCol)).append("\n");
        sb.append("    maxTileCol: ").append(this.toIndentedString(this.maxTileCol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

