/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.ogcapi.api.TilesApi;
import org.apache.baremaps.ogcapi.model.TileSetItem;
import org.apache.baremaps.ogcapi.model.TileSets;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.vectortile.tilejson.TileJSON;

@Singleton
public class TilesResource
implements TilesApi {
    public static final String TILE_ENCODING = "gzip";
    public static final String TILE_TYPE = "application/vnd.mapbox-vector-tile";
    private final TileJSON tileJSON;
    private final TileStore tileStore;

    @Inject
    public TilesResource(@Context UriInfo uriInfo, @Named(value="tileset") Path tilesetPath, ObjectMapper objectMapper, TileStore tileStore) throws IOException {
        this.tileJSON = (TileJSON)objectMapper.readValue(new ConfigReader().read(tilesetPath), TileJSON.class);
        this.tileJSON.setTiles(List.of(uriInfo.getBaseUri().toString() + "tiles/default/{z}/{x}/{y}"));
        this.tileStore = tileStore;
    }

    @Override
    public Response getTileSets() {
        TileSetItem tileSetItem = new TileSetItem();
        tileSetItem.setTitle("default");
        TileSets tileSets = new TileSets();
        tileSets.setTileSets(List.of(tileSetItem));
        return Response.ok((Object)tileSets).build();
    }

    @Override
    public Response getTileSet(String tileSetId) {
        return Response.ok((Object)this.tileJSON).build();
    }

    @Override
    public Response getTile(String tileSetId, String tileMatrix, Integer tileRow, Integer tileCol) {
        int z = Integer.parseInt(tileMatrix);
        int x = tileRow;
        int y = tileCol;
        TileCoord tileCoord = new TileCoord(x, y, z);
        try {
            ByteBuffer blob = this.tileStore.read(tileCoord);
            if (blob != null) {
                return Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)TILE_TYPE).header("Content-Encoding", (Object)TILE_ENCODING).entity((Object)blob.array()).build();
            }
            return Response.status((int)204).build();
        }
        catch (TileStoreException ex) {
            return Response.status((int)404).build();
        }
    }
}

