/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.color;

import mil.nga.color.ColorUtils;

public class Color {
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private float opacity = 1.0f;

    public static Color black() {
        return Color.color("#000000");
    }

    public static Color blue() {
        return Color.color("#0000FF");
    }

    public static Color brown() {
        return Color.color("#A52A2A");
    }

    public static Color cyan() {
        return Color.color("#00FFFF");
    }

    public static Color darkGray() {
        return Color.color("#444444");
    }

    public static Color gray() {
        return Color.color("#888888");
    }

    public static Color green() {
        return Color.color("#00FF00");
    }

    public static Color lightGray() {
        return Color.color("#CCCCCC");
    }

    public static Color magenta() {
        return Color.color("#FF00FF");
    }

    public static Color orange() {
        return Color.color("#FFA500");
    }

    public static Color pink() {
        return Color.color("#FFC0CB");
    }

    public static Color purple() {
        return Color.color("#800080");
    }

    public static Color red() {
        return Color.color("#FF0000");
    }

    public static Color violet() {
        return Color.color("#EE82EE");
    }

    public static Color white() {
        return Color.color("#FFFFFF");
    }

    public static Color yellow() {
        return Color.color("#FFFF00");
    }

    public static Color color(String color) {
        return new Color(color);
    }

    public static Color color(String color, float opacity) {
        return new Color(color, opacity);
    }

    public static Color color(String color, int alpha) {
        return new Color(color, alpha);
    }

    public static Color color(String red, String green, String blue) {
        return new Color(red, green, blue);
    }

    public static Color color(String red, String green, String blue, String alpha) {
        return new Color(red, green, blue, alpha);
    }

    public static Color color(String red, String green, String blue, float opacity) {
        return new Color(red, green, blue, opacity);
    }

    public static Color color(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    public static Color color(int red, int green, int blue, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    public static Color color(int red, int green, int blue, float opacity) {
        return new Color(red, green, blue, opacity);
    }

    public static Color color(float red, float green, float blue) {
        return new Color(red, green, blue);
    }

    public static Color color(float red, float green, float blue, float opacity) {
        return new Color(red, green, blue, opacity);
    }

    public static Color color(float[] hsl) {
        return new Color(hsl);
    }

    public static Color color(float[] hsl, float alpha) {
        return new Color(hsl, alpha);
    }

    public static Color color(int color) {
        return new Color(color);
    }

    public Color() {
    }

    public Color(String color) {
        this.setColor(color);
    }

    public Color(String color, float opacity) {
        this.setColor(color, opacity);
    }

    public Color(String color, int alpha) {
        this.setColor(color, alpha);
    }

    public Color(String red, String green, String blue) {
        this.setColor(red, green, blue);
    }

    public Color(String red, String green, String blue, String alpha) {
        this.setColor(red, green, blue, alpha);
    }

    public Color(String red, String green, String blue, float opacity) {
        this.setColor(red, green, blue, opacity);
    }

    public Color(int red, int green, int blue) {
        this.setColor(red, green, blue);
    }

    public Color(int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue, alpha);
    }

    public Color(int red, int green, int blue, float opacity) {
        this.setColor(red, green, blue, opacity);
    }

    public Color(float red, float green, float blue) {
        this.setColor(red, green, blue);
    }

    public Color(float red, float green, float blue, float opacity) {
        this.setColor(red, green, blue, opacity);
    }

    public Color(float[] hsl) {
        if (hsl.length > 3) {
            this.setColorByHSL(hsl[0], hsl[1], hsl[2], hsl[3]);
        } else {
            this.setColorByHSL(hsl[0], hsl[1], hsl[2]);
        }
    }

    public Color(float[] hsl, float alpha) {
        this.setColorByHSL(hsl[0], hsl[1], hsl[2], alpha);
    }

    public Color(int color) {
        this.setColor(color);
    }

    public Color(Color color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
        this.opacity = color.opacity;
    }

    public void setColor(String color) {
        this.setRed(ColorUtils.getRed(color));
        this.setGreen(ColorUtils.getGreen(color));
        this.setBlue(ColorUtils.getBlue(color));
        String alpha = ColorUtils.getAlpha(color);
        if (alpha != null) {
            this.setAlpha(alpha);
        }
    }

    public void setColor(String color, float opacity) {
        this.setColor(color);
        this.setOpacity(opacity);
    }

    public void setColor(String color, int alpha) {
        this.setColor(color);
        this.setAlpha(alpha);
    }

    public void setColor(String red, String green, String blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(String red, String green, String blue, String alpha) {
        this.setColor(red, green, blue);
        this.setAlpha(alpha);
    }

    public void setColor(String red, String green, String blue, float opacity) {
        this.setColor(red, green, blue);
        this.setOpacity(opacity);
    }

    public void setColor(int red, int green, int blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue);
        this.setAlpha(alpha);
    }

    public void setColor(int red, int green, int blue, float opacity) {
        this.setColor(red, green, blue);
        this.setOpacity(opacity);
    }

    public void setColor(float red, float green, float blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(float red, float green, float blue, float opacity) {
        this.setColor(red, green, blue);
        this.setOpacity(opacity);
    }

    public void setColorByHSL(float hue, float saturation, float lightness) {
        float[] arithmeticRGB = ColorUtils.toArithmeticRGB(hue, saturation, lightness);
        this.setRed(arithmeticRGB[0]);
        this.setGreen(arithmeticRGB[1]);
        this.setBlue(arithmeticRGB[2]);
    }

    public void setColorByHSL(float hue, float saturation, float lightness, float alpha) {
        this.setColorByHSL(hue, saturation, lightness);
        this.setAlpha(alpha);
    }

    public void setColor(int color) {
        this.setRed(ColorUtils.getRed(color));
        this.setGreen(ColorUtils.getGreen(color));
        this.setBlue(ColorUtils.getBlue(color));
        if (color > 0xFFFFFF || color < 0) {
            this.setAlpha(ColorUtils.getAlpha(color));
        }
    }

    public void setRed(String red) {
        this.setRed(ColorUtils.toArithmeticRGB(red));
    }

    public void setGreen(String green) {
        this.setGreen(ColorUtils.toArithmeticRGB(green));
    }

    public void setBlue(String blue) {
        this.setBlue(ColorUtils.toArithmeticRGB(blue));
    }

    public void setAlpha(String alpha) {
        this.setOpacity(ColorUtils.toArithmeticRGB(alpha));
    }

    public void setRed(int red) {
        this.setRed(ColorUtils.toHex(red));
    }

    public void setGreen(int green) {
        this.setGreen(ColorUtils.toHex(green));
    }

    public void setBlue(int blue) {
        this.setBlue(ColorUtils.toHex(blue));
    }

    public void setAlpha(int alpha) {
        this.setOpacity(ColorUtils.toArithmeticRGB(alpha));
    }

    public void setRed(float red) {
        ColorUtils.validateArithmeticRGB(red);
        this.red = red;
    }

    public void setGreen(float green) {
        ColorUtils.validateArithmeticRGB(green);
        this.green = green;
    }

    public void setBlue(float blue) {
        ColorUtils.validateArithmeticRGB(blue);
        this.blue = blue;
    }

    public void setOpacity(float opacity) {
        ColorUtils.validateArithmeticRGB(opacity);
        this.opacity = opacity;
    }

    public void setAlpha(float alpha) {
        this.setOpacity(alpha);
    }

    public boolean isOpaque() {
        return this.opacity == 1.0f;
    }

    public String getColorHex() {
        return ColorUtils.toColor(this.getRedHex(), this.getGreenHex(), this.getBlueHex());
    }

    public String getColorHexWithAlpha() {
        return ColorUtils.toColorWithAlpha(this.getRedHex(), this.getGreenHex(), this.getBlueHex(), this.getAlphaHex());
    }

    public String getColorHexShorthand() {
        return ColorUtils.toColorShorthand(this.getRedHex(), this.getGreenHex(), this.getBlueHex());
    }

    public String getColorHexShorthandWithAlpha() {
        return ColorUtils.toColorShorthandWithAlpha(this.getRedHex(), this.getGreenHex(), this.getBlueHex(), this.getAlphaHex());
    }

    public int getColor() {
        return ColorUtils.toColor(this.getRed(), this.getGreen(), this.getBlue());
    }

    public int getColorWithAlpha() {
        return ColorUtils.toColorWithAlpha(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public String getRedHex() {
        return ColorUtils.toHex(this.red);
    }

    public String getGreenHex() {
        return ColorUtils.toHex(this.green);
    }

    public String getBlueHex() {
        return ColorUtils.toHex(this.blue);
    }

    public String getAlphaHex() {
        return ColorUtils.toHex(this.opacity);
    }

    public String getRedHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getRedHex());
    }

    public String getGreenHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getGreenHex());
    }

    public String getBlueHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getBlueHex());
    }

    public String getAlphaHexShorthand() {
        return ColorUtils.shorthandHexSingle(this.getAlphaHex());
    }

    public int getRed() {
        return ColorUtils.toRGB(this.red);
    }

    public int getGreen() {
        return ColorUtils.toRGB(this.green);
    }

    public int getBlue() {
        return ColorUtils.toRGB(this.blue);
    }

    public int getAlpha() {
        return ColorUtils.toRGB(this.opacity);
    }

    public float getRedArithmetic() {
        return this.red;
    }

    public float getGreenArithmetic() {
        return this.green;
    }

    public float getBlueArithmetic() {
        return this.blue;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public float getAlphaArithmetic() {
        return this.getOpacity();
    }

    public float[] getHSL() {
        return ColorUtils.toHSL(this.red, this.green, this.blue);
    }

    public float getHue() {
        return this.getHSL()[0];
    }

    public float getSaturation() {
        return this.getHSL()[1];
    }

    public float getLightness() {
        return this.getHSL()[2];
    }

    public Color copy() {
        return new Color(this);
    }
}

