/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Path;
import javax.sql.DataSource;
import org.apache.baremaps.database.schema.DataTableAdapter;
import org.apache.baremaps.database.schema.DataTableGeometryTransformer;
import org.apache.baremaps.storage.postgres.PostgresDataSchema;
import org.apache.baremaps.storage.shapefile.ShapefileDataTable;
import org.apache.baremaps.utils.ProjectionTransformer;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ImportShapefile(Path file, Object database, Integer sourceSRID, Integer targetSRID) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ImportShapefile.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        try {
            ShapefileDataTable shapefileDataTable = new ShapefileDataTable(path);
            DataSource dataSource = context.getDataSource(this.database);
            PostgresDataSchema postgresDataStore = new PostgresDataSchema(dataSource);
            DataTableGeometryTransformer rowTransformer = new DataTableGeometryTransformer(shapefileDataTable, new ProjectionTransformer(this.sourceSRID, this.targetSRID));
            DataTableAdapter transformedDataTable = new DataTableAdapter(shapefileDataTable, rowTransformer);
            postgresDataStore.add(transformedDataTable);
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
    }
}

