/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.baremaps.database.collection.AbstractDataCollection;
import org.apache.baremaps.database.schema.AbstractDataTable;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.storage.flatgeobuf.FlatGeoBufTypeConversion;
import org.locationtech.jts.geom.Geometry;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.Constants;
import org.wololo.flatgeobuf.GeometryConversions;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.PackedRTree;
import org.wololo.flatgeobuf.generated.Feature;

public class FlatGeoBufDataTable
extends AbstractDataTable {
    private final Path file;
    private DataRowType rowType;

    public FlatGeoBufDataTable(Path file) {
        this.file = file;
        this.rowType = FlatGeoBufDataTable.readRowType(file);
    }

    public FlatGeoBufDataTable(Path file, DataRowType rowType) {
        this.file = file;
        this.rowType = rowType;
    }

    @Override
    public DataRowType rowType() {
        return this.rowType;
    }

    public static DataRowType readRowType(Path file) {
        DataRowType dataRowType;
        block8: {
            FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);
            try {
                ByteBuffer buffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);
                HeaderMeta headerMeta = FlatGeoBufDataTable.readHeaderMeta(channel, buffer);
                dataRowType = FlatGeoBufTypeConversion.asRowType(headerMeta);
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            channel.close();
        }
        return dataRowType;
    }

    @Override
    public Iterator<DataRow> iterator() {
        try {
            FileChannel channel = FileChannel.open(this.file, StandardOpenOption.READ);
            ByteBuffer buffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);
            HeaderMeta headerMeta = FlatGeoBufDataTable.readHeaderMeta(channel, buffer);
            channel.position(headerMeta.offset);
            long indexOffset = headerMeta.offset;
            long indexSize = PackedRTree.calcSize((int)((int)headerMeta.featuresCount), (int)headerMeta.indexNodeSize);
            channel.position(indexOffset + indexSize);
            buffer.clear();
            return new RowIterator(channel, headerMeta, this.rowType, buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long sizeAsLong() {
        long l;
        block8: {
            FileChannel channel = FileChannel.open(this.file, StandardOpenOption.READ);
            try {
                ByteBuffer buffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);
                HeaderMeta headerMeta = FlatGeoBufDataTable.readHeaderMeta(channel, buffer);
                l = headerMeta.featuresCount;
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channel.close();
        }
        return l;
    }

    private static HeaderMeta readHeaderMeta(SeekableByteChannel channel, ByteBuffer buffer) throws IOException {
        channel.read(buffer);
        buffer.flip();
        return HeaderMeta.read((ByteBuffer)buffer);
    }

    public void write(Collection<DataRow> features) throws IOException {
        try (FileChannel channel = FileChannel.open(this.file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
             OutputStream outputStream = Channels.newOutputStream(channel);){
            long l;
            outputStream.write(Constants.MAGIC_BYTES);
            FlatBufferBuilder bufferBuilder = new FlatBufferBuilder();
            HeaderMeta headerMeta = new HeaderMeta();
            headerMeta.geometryType = 0;
            headerMeta.indexNodeSize = 16;
            headerMeta.srid = 3857;
            if (features instanceof AbstractDataCollection) {
                AbstractDataCollection c = (AbstractDataCollection)features;
                l = c.sizeAsLong();
            } else {
                l = features.size();
            }
            headerMeta.featuresCount = l;
            headerMeta.name = this.rowType.name();
            headerMeta.columns = FlatGeoBufTypeConversion.asColumns(this.rowType.columns());
            HeaderMeta.write((HeaderMeta)headerMeta, (OutputStream)outputStream, (FlatBufferBuilder)bufferBuilder);
            int indexSize = (int)PackedRTree.calcSize((int)((int)headerMeta.featuresCount), (int)headerMeta.indexNodeSize);
            for (int i = 0; i < indexSize; ++i) {
                outputStream.write(0);
            }
            Iterator<DataRow> iterator = features.iterator();
            while (iterator.hasNext()) {
                FlatBufferBuilder featureBuilder = new FlatBufferBuilder(4096);
                DataRow row = iterator.next();
                ByteBuffer propertiesBuffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);
                List<Object> properties = row.values().stream().filter(v -> !(v instanceof Geometry)).toList();
                for (int i = 0; i < properties.size(); ++i) {
                    ColumnMeta column = (ColumnMeta)headerMeta.columns.get(i);
                    Object value = properties.get(i);
                    propertiesBuffer.putShort((short)i);
                    FlatGeoBufTypeConversion.writeValue(propertiesBuffer, column, value);
                }
                if (propertiesBuffer.position() > 0) {
                    propertiesBuffer.flip();
                }
                int propertiesOffset = Feature.createPropertiesVector((FlatBufferBuilder)featureBuilder, (ByteBuffer)propertiesBuffer);
                Optional<Geometry> geometry = row.values().stream().filter(v -> v instanceof Geometry).map(Geometry.class::cast).findFirst();
                int geometryOffset = geometry.isPresent() ? GeometryConversions.serialize((FlatBufferBuilder)featureBuilder, (Geometry)geometry.get(), (byte)headerMeta.geometryType) : 0;
                int featureOffset = Feature.createFeature((FlatBufferBuilder)featureBuilder, (int)geometryOffset, (int)propertiesOffset, (int)0);
                featureBuilder.finishSizePrefixed(featureOffset);
                ByteBuffer data = featureBuilder.dataBuffer();
                while (data.hasRemaining()) {
                    channel.write(data);
                }
            }
        }
    }

    public static class RowIterator
    implements Iterator<DataRow> {
        private final HeaderMeta headerMeta;
        private final DataRowType rowType;
        private final SeekableByteChannel channel;
        private final ByteBuffer buffer;
        private long cursor = 0L;

        public RowIterator(SeekableByteChannel channel, HeaderMeta headerMeta, DataRowType rowType, ByteBuffer buffer) {
            this.channel = channel;
            this.headerMeta = headerMeta;
            this.rowType = rowType;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.headerMeta.featuresCount;
        }

        @Override
        public DataRow next() {
            try {
                this.channel.read(this.buffer);
                this.buffer.flip();
                int featureSize = this.buffer.getInt();
                DataRow row = FlatGeoBufTypeConversion.asRow(this.headerMeta, this.rowType, Feature.getRootAsFeature((ByteBuffer)this.buffer));
                this.buffer.position(4 + featureSize);
                this.buffer.compact();
                ++this.cursor;
                return row;
            }
            catch (IOException e) {
                throw new NoSuchElementException(e);
            }
        }
    }
}

