/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;

public class UserRelatedTable
extends UserCustomTable {
    private final String relationName;
    private final String dataType;

    public UserRelatedTable(String tableName, String relationName, String dataType, List<UserCustomColumn> columns) {
        this(tableName, relationName, dataType, columns, null);
    }

    public UserRelatedTable(String tableName, String relationName, String dataType, List<UserCustomColumn> columns, Collection<String> requiredColumns) {
        super(tableName, columns, requiredColumns);
        this.relationName = relationName;
        this.dataType = dataType;
    }

    public UserRelatedTable(String relationName, String dataType, UserCustomTable userCustomTable) {
        super(userCustomTable);
        this.relationName = relationName;
        this.dataType = dataType;
    }

    public String getRelationName() {
        return this.relationName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    protected void validateContents(Contents contents) {
        String contentsDataType = contents.getDataTypeName();
        if (contentsDataType == null || !contentsDataType.equals(this.dataType)) {
            throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + this.getClass().getSimpleName() + " must have a data type of " + this.dataType);
        }
    }
}

