/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.extension.coverage.GriddedTile;

public class GriddedTileDao
extends GeoPackageDao<GriddedTile, Long> {
    public static GriddedTileDao create(GeoPackageCore geoPackage) {
        return GriddedTileDao.create(geoPackage.getDatabase());
    }

    public static GriddedTileDao create(GeoPackageCoreConnection db) {
        return (GriddedTileDao)((Object)GeoPackageDao.createDao(db, GriddedTile.class));
    }

    public GriddedTileDao(ConnectionSource connectionSource, Class<GriddedTile> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public List<GriddedTile> query(Contents contents) {
        return this.query(contents.getTableName());
    }

    public List<GriddedTile> query(String tableName) {
        List results = null;
        try {
            results = this.queryForEq("tpudt_name", tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Gridded Tile objects by Table Name: " + tableName, e);
        }
        return results;
    }

    public GriddedTile query(String tableName, long tileId) {
        GriddedTile griddedTile = null;
        try {
            QueryBuilder qb = this.queryBuilder();
            qb.where().eq("tpudt_name", (Object)tableName).and().eq("tpudt_id", (Object)tileId);
            PreparedQuery query = qb.prepare();
            griddedTile = (GriddedTile)this.queryForFirst(query);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Gridded Tile objects by Table Name: " + tableName + ", Tile Id: " + tileId, e);
        }
        return griddedTile;
    }

    public int delete(Contents contents) {
        return this.delete(contents.getTableName());
    }

    public int delete(String tableName) {
        DeleteBuilder db = this.deleteBuilder();
        int deleted = 0;
        try {
            db.where().eq("tpudt_name", (Object)tableName);
            PreparedDelete deleteQuery = db.prepare();
            deleted = this.delete(deleteQuery);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Gridded Tile by Table Name: " + tableName, e);
        }
        return deleted;
    }
}

