/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DelegatingToBufferHttpPayloadWriter;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpSerializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class HttpStringSerializer
implements HttpSerializer<String> {
    static final HttpStringSerializer UTF8_STRING_SERIALIZER = new HttpStringSerializer(StandardCharsets.UTF_8, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.TEXT_PLAIN_UTF_8));
    private final Charset charset;
    private final Consumer<HttpHeaders> addContentType;

    HttpStringSerializer(Charset charset, Consumer<HttpHeaders> addContentType) {
        this.charset = charset;
        this.addContentType = addContentType;
    }

    @Override
    public Buffer serialize(HttpHeaders headers, String value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return allocator.fromSequence((CharSequence)value, this.charset);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<String> value, final BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return () -> {
            final BlockingIterator iterator = value.iterator();
            return new BlockingIterator<Buffer>(){

                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return iterator.hasNext(timeout, unit);
                }

                public Buffer next(long timeout, TimeUnit unit) throws TimeoutException {
                    return HttpStringSerializer.this.toBuffer((String)iterator.next(timeout, unit), allocator);
                }

                public void close() throws Exception {
                    iterator.close();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Buffer next() {
                    return HttpStringSerializer.this.toBuffer((String)iterator.next(), allocator);
                }
            };
        };
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<String> value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return value.map(str -> this.toBuffer((String)str, allocator));
    }

    @Override
    public HttpPayloadWriter<String> serialize(HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return new DelegatingToBufferHttpPayloadWriter<String>(payloadWriter, allocator){

            public void write(String object) throws IOException {
                this.delegate.write(HttpStringSerializer.this.toBuffer(object, this.allocator));
            }
        };
    }

    @Nullable
    private Buffer toBuffer(@Nullable String value, BufferAllocator allocator) {
        return value == null ? null : allocator.fromSequence((CharSequence)value, this.charset);
    }
}

