/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultBlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultHttpResponse;
import io.servicetalk.http.api.DefaultHttpResponseMetaData;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.StreamingHttpPayloadHolder;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class DefaultStreamingHttpResponse
extends DefaultHttpResponseMetaData
implements StreamingHttpResponse,
PayloadInfo {
    private final StreamingHttpPayloadHolder payloadHolder;

    DefaultStreamingHttpResponse(HttpResponseStatus status, HttpProtocolVersion version, HttpHeaders headers, @Nullable ContextMap context, BufferAllocator allocator, @Nullable Publisher<?> payloadBody, DefaultPayloadInfo payloadInfo, HttpHeadersFactory headersFactory) {
        super(status, version, headers, context);
        this.payloadHolder = new StreamingHttpPayloadHolder(headers, allocator, payloadBody, payloadInfo, headersFactory);
    }

    @Override
    public StreamingHttpResponse version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    public StreamingHttpResponse status(HttpResponseStatus status) {
        super.status(status);
        return this;
    }

    @Override
    @Deprecated
    public StreamingHttpResponse encoding(ContentCodec encoding) {
        super.encoding(encoding);
        return this;
    }

    @Override
    public StreamingHttpResponse context(ContextMap context) {
        super.context(context);
        return this;
    }

    @Override
    public Publisher<Buffer> payloadBody() {
        return this.payloadHolder.payloadBody();
    }

    @Override
    public <T> Publisher<T> payloadBody(HttpStreamingDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody(), this.payloadHolder.allocator());
    }

    @Override
    public Publisher<Object> messageBody() {
        return this.payloadHolder.messageBody();
    }

    @Override
    public StreamingHttpResponse payloadBody(Publisher<Buffer> payloadBody) {
        this.payloadHolder.payloadBody(payloadBody);
        return this;
    }

    @Override
    @Deprecated
    public <T> StreamingHttpResponse payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        this.payloadHolder.transformPayloadBody(bufPub -> serializer.serialize(this.headers(), payloadBody, this.payloadHolder.allocator()));
        return this;
    }

    @Override
    public <T> StreamingHttpResponse payloadBody(Publisher<T> payloadBody, HttpStreamingSerializer<T> serializer) {
        this.payloadHolder.payloadBody(payloadBody, serializer);
        return this;
    }

    @Override
    @Deprecated
    public <T> StreamingHttpResponse transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        this.payloadHolder.transformPayloadBody(bufPub -> serializer.serialize(this.headers(), (Publisher)transformer.apply((Publisher<Buffer>)bufPub), this.payloadHolder.allocator()));
        return this;
    }

    @Override
    public <T> StreamingHttpResponse transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpStreamingSerializer<T> serializer) {
        this.payloadHolder.transformPayloadBody(transformer, serializer);
        return this;
    }

    @Override
    public <T, R> StreamingHttpResponse transformPayloadBody(Function<Publisher<T>, Publisher<R>> transformer, HttpStreamingDeserializer<T> deserializer, HttpStreamingSerializer<R> serializer) {
        return this.transformPayloadBody((Publisher<Buffer> bufPub) -> (Publisher)transformer.apply(deserializer.deserialize(this.headers(), (Publisher<Buffer>)bufPub, this.payloadHolder.allocator())), serializer);
    }

    @Override
    public StreamingHttpResponse transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        this.payloadHolder.transformPayloadBody(transformer);
        return this;
    }

    @Override
    public StreamingHttpResponse transformMessageBody(UnaryOperator<Publisher<?>> transformer) {
        this.payloadHolder.transformMessageBody(transformer);
        return this;
    }

    @Override
    public <T> StreamingHttpResponse transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.payloadHolder.transform(trailersTransformer);
        return this;
    }

    @Override
    public <T, S> StreamingHttpResponse transform(TrailersTransformer<T, S> trailersTransformer, HttpStreamingDeserializer<S> serializer) {
        this.payloadHolder.transform(trailersTransformer, serializer);
        return this;
    }

    @Override
    public Single<HttpResponse> toResponse() {
        return this.payloadHolder.aggregate().map(pair -> new DefaultHttpResponse(this, pair.payload, pair.trailers));
    }

    @Override
    public BlockingStreamingHttpResponse toBlockingStreamingResponse() {
        return new DefaultBlockingStreamingHttpResponse(this);
    }

    @Override
    public boolean isEmpty() {
        return this.payloadHolder.isEmpty();
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.payloadHolder.isSafeToAggregate();
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.payloadHolder.mayHaveTrailers();
    }

    @Override
    public boolean isGenericTypeBuffer() {
        return this.payloadHolder.isGenericTypeBuffer();
    }

    StreamingHttpPayloadHolder payloadHolder() {
        return this.payloadHolder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultStreamingHttpResponse that = (DefaultStreamingHttpResponse)o;
        return this.payloadHolder.equals(that.payloadHolder);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.payloadHolder.hashCode();
        return result;
    }
}

