/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.vertical;

import mil.nga.crs.CRSType;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.Dynamic;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.vertical.VerticalDatumEnsemble;
import mil.nga.crs.vertical.VerticalReferenceFrame;

public class VerticalCoordinateReferenceSystem
extends SimpleCoordinateReferenceSystem {
    private VerticalReferenceFrame referenceFrame = null;
    private VerticalDatumEnsemble datumEnsemble = null;
    private Dynamic dynamic = null;
    private String geoidModelName;
    private Identifier geoidModelIdentifier;

    public VerticalCoordinateReferenceSystem() {
        super(CRSType.VERTICAL);
    }

    public VerticalCoordinateReferenceSystem(String name, VerticalReferenceFrame referenceFrame, CoordinateSystem coordinateSystem) {
        super(name, CRSType.VERTICAL, coordinateSystem);
        this.setReferenceFrame(referenceFrame);
    }

    public VerticalCoordinateReferenceSystem(String name, VerticalDatumEnsemble datumEnsemble, CoordinateSystem coordinateSystem) {
        super(name, CRSType.VERTICAL, coordinateSystem);
        this.setDatumEnsemble(datumEnsemble);
    }

    public VerticalCoordinateReferenceSystem(String name, Dynamic dynamic, VerticalReferenceFrame referenceFrame, CoordinateSystem coordinateSystem) {
        super(name, CRSType.VERTICAL, coordinateSystem);
        this.setDynamic(dynamic);
        this.setReferenceFrame(referenceFrame);
    }

    public VerticalReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean hasReferenceFrame() {
        return this.getReferenceFrame() != null;
    }

    public void setReferenceFrame(VerticalReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public VerticalDatumEnsemble getDatumEnsemble() {
        return this.datumEnsemble;
    }

    public boolean hasDatumEnsemble() {
        return this.getDatumEnsemble() != null;
    }

    public void setDatumEnsemble(VerticalDatumEnsemble datumEnsemble) {
        this.datumEnsemble = datumEnsemble;
    }

    public Dynamic getDynamic() {
        return this.dynamic;
    }

    public boolean hasDynamic() {
        return this.getDynamic() != null;
    }

    public void setDynamic(Dynamic dynamic) {
        this.dynamic = dynamic;
    }

    public String getGeoidModelName() {
        return this.geoidModelName;
    }

    public boolean hasGeoidModelName() {
        return this.getGeoidModelName() != null;
    }

    public void setGeoidModelName(String geoidModelName) {
        this.geoidModelName = geoidModelName;
    }

    public Identifier getGeoidModelIdentifier() {
        return this.geoidModelIdentifier;
    }

    public boolean hasGeoidModelIdentifier() {
        return this.getGeoidModelIdentifier() != null;
    }

    public void setGeoidModelIdentifier(Identifier geoidModelIdentifier) {
        this.geoidModelIdentifier = geoidModelIdentifier;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dynamic == null ? 0 : this.dynamic.hashCode());
        result = 31 * result + (this.geoidModelIdentifier == null ? 0 : this.geoidModelIdentifier.hashCode());
        result = 31 * result + (this.geoidModelName == null ? 0 : this.geoidModelName.hashCode());
        result = 31 * result + (this.datumEnsemble == null ? 0 : this.datumEnsemble.hashCode());
        result = 31 * result + (this.referenceFrame == null ? 0 : this.referenceFrame.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VerticalCoordinateReferenceSystem other = (VerticalCoordinateReferenceSystem)obj;
        if (this.dynamic == null ? other.dynamic != null : !this.dynamic.equals(other.dynamic)) {
            return false;
        }
        if (this.geoidModelIdentifier == null ? other.geoidModelIdentifier != null : !this.geoidModelIdentifier.equals(other.geoidModelIdentifier)) {
            return false;
        }
        if (this.geoidModelName == null ? other.geoidModelName != null : !this.geoidModelName.equals(other.geoidModelName)) {
            return false;
        }
        if (this.datumEnsemble == null ? other.datumEnsemble != null : !this.datumEnsemble.equals(other.datumEnsemble)) {
            return false;
        }
        return !(this.referenceFrame == null ? other.referenceFrame != null : !this.referenceFrame.equals(other.referenceFrame));
    }
}

