/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.Http2Exception;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaDataFactory;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.AbstractH2DuplexHandler;
import io.servicetalk.http.netty.H2ToStH1Utils;
import io.servicetalk.http.netty.HeaderUtils;
import io.servicetalk.http.netty.NettyH2HeadersToHttpHeaders;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import javax.annotation.Nullable;

final class H2ToStH1ClientDuplexHandler
extends AbstractH2DuplexHandler {
    private boolean readHeaders;
    private final HttpScheme scheme;
    @Nullable
    private HttpRequestMethod method;
    private boolean waitForContinuation;

    H2ToStH1ClientDuplexHandler(boolean sslEnabled, BufferAllocator allocator, HttpHeadersFactory headersFactory, CloseHandler closeHandler, ConnectionObserver.StreamObserver observer) {
        super(allocator, headersFactory, closeHandler, observer);
        this.scheme = sslEnabled ? HttpScheme.HTTPS : HttpScheme.HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpRequestMetaData) {
            this.closeHandler.protocolPayloadBeginOutbound(ctx);
            HttpRequestMetaData metaData = (HttpRequestMetaData)msg;
            HttpHeaders h1Headers = metaData.headers();
            this.waitForContinuation = HeaderUtils.REQ_EXPECT_CONTINUE.test(metaData);
            CharSequence host = h1Headers.getAndRemove((CharSequence)HttpHeaderNames.HOST);
            Http2Headers h2Headers = H2ToStH1Utils.h1HeadersToH2Headers(h1Headers);
            if (host == null) {
                host = metaData.host();
                if (host != null) {
                    h2Headers.authority(host);
                }
            } else {
                h2Headers.authority(host);
            }
            this.method = metaData.method();
            h2Headers.method((CharSequence)this.method.name());
            if (!HttpRequestMethod.CONNECT.equals((Object)this.method)) {
                h2Headers.scheme((CharSequence)this.scheme.name());
                h2Headers.path((CharSequence)metaData.requestTarget());
            }
            try {
                this.writeMetaData(ctx, (HttpMetaData)metaData, h2Headers, true, promise);
            }
            finally {
                Http2StreamChannel streamChannel = (Http2StreamChannel)ctx.channel();
                int streamId = streamChannel.stream().id();
                if (streamId > 0) {
                    this.observer.streamIdAssigned((long)streamId);
                }
            }
        } else if (msg instanceof Buffer) {
            H2ToStH1ClientDuplexHandler.writeBuffer(ctx, (Buffer)msg, promise);
        } else if (msg instanceof HttpHeaders) {
            this.writeTrailers(ctx, msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Http2Exception {
        if (msg instanceof Http2HeadersFrame) {
            HttpResponseStatus httpStatus;
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            int streamId = headersFrame.stream().id();
            Http2Headers h2Headers = headersFrame.headers();
            if (!this.readHeaders) {
                boolean realResponse;
                CharSequence status = (CharSequence)h2Headers.getAndRemove((Object)Http2Headers.PseudoHeaderName.STATUS.value());
                if (status == null) {
                    throw H2ToStH1ClientDuplexHandler.noStatus(ctx, streamId);
                }
                httpStatus = HttpResponseStatus.of((CharSequence)status);
                boolean bl = realResponse = !H2ToStH1ClientDuplexHandler.isInterim(httpStatus);
                if (realResponse) {
                    this.closeHandler.protocolPayloadBeginInbound(ctx);
                }
                if (this.waitForContinuation) {
                    if (httpStatus.code() == HttpResponseStatus.CONTINUE.code() || httpStatus.statusClass() == HttpResponseStatus.StatusClass.SUCCESSFUL_2XX) {
                        this.waitForContinuation = false;
                        ctx.fireUserEventTriggered((Object)DefaultNettyConnection.ContinueUserEvent.INSTANCE);
                    } else if (realResponse) {
                        this.waitForContinuation = false;
                        ctx.fireUserEventTriggered((Object)DefaultNettyConnection.CancelWriteUserEvent.INSTANCE);
                    }
                }
                if (!realResponse) {
                    return;
                }
                this.readHeaders = true;
            } else {
                httpStatus = null;
            }
            if (headersFrame.isEndStream()) {
                if (httpStatus != null) {
                    this.fireFullResponse(ctx, h2Headers, httpStatus, streamId);
                } else {
                    ctx.fireChannelRead((Object)this.h2HeadersToH1HeadersClient(ctx, h2Headers, null, false, streamId));
                }
                this.closeHandler.protocolPayloadEndInbound(ctx);
            } else {
                if (httpStatus == null) {
                    throw H2ToStH1ClientDuplexHandler.noStatus(ctx, streamId);
                }
                ctx.fireChannelRead((Object)HttpResponseMetaDataFactory.newResponseMetaData((HttpProtocolVersion)HttpProtocolVersion.HTTP_2_0, (HttpResponseStatus)httpStatus, (HttpHeaders)this.h2HeadersToH1HeadersClient(ctx, h2Headers, httpStatus, false, streamId)));
            }
        } else if (msg instanceof Http2DataFrame) {
            this.readDataFrame(ctx, msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private static Http2Exception noStatus(ChannelHandlerContext ctx, int streamId) {
        return H2ToStH1ClientDuplexHandler.protocolError(ctx, streamId, false, "Incoming response must have '" + Http2Headers.PseudoHeaderName.STATUS.value() + "' header");
    }

    private void fireFullResponse(ChannelHandlerContext ctx, Http2Headers h2Headers, HttpResponseStatus httpStatus, int streamId) throws Http2Exception {
        assert (this.method != null);
        ctx.fireChannelRead((Object)HttpResponseMetaDataFactory.newResponseMetaData((HttpProtocolVersion)HttpProtocolVersion.HTTP_2_0, (HttpResponseStatus)httpStatus, (HttpHeaders)this.h2HeadersToH1HeadersClient(ctx, h2Headers, httpStatus, true, streamId)));
    }

    private NettyH2HeadersToHttpHeaders h2HeadersToH1HeadersClient(ChannelHandlerContext ctx, Http2Headers h2Headers, @Nullable HttpResponseStatus httpStatus, boolean fullResponse, int streamId) throws Http2Exception {
        assert (this.method != null);
        H2ToStH1Utils.h2HeadersSanitizeForH1(h2Headers);
        if (httpStatus != null) {
            int statusCode = httpStatus.code();
            if (!h2Headers.contains((Object)HttpHeaderNames.CONTENT_LENGTH)) {
                if (HeaderUtils.serverMaySendPayloadBodyFor(statusCode, this.method) && fullResponse) {
                    h2Headers.set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
                }
            } else if (!HeaderUtils.responseMayHaveContent(statusCode, this.method)) {
                throw H2ToStH1ClientDuplexHandler.protocolError(ctx, streamId, fullResponse, "content-length (" + h2Headers.get((Object)HttpHeaderNames.CONTENT_LENGTH) + ") header is not expected for status code " + statusCode + " in response to " + this.method.name() + " request");
            }
        }
        return new NettyH2HeadersToHttpHeaders(h2Headers, this.headersFactory.validateCookies(), this.headersFactory.validateValues());
    }

    static boolean isInterim(HttpResponseStatus status) {
        return status.statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX;
    }
}

