/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractStreamingHttpConnection;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.transport.api.ConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoThreadFactory;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.api.TransportObservers;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLBHttpConnectionFactory<ResolvedAddress>
implements ConnectionFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLBHttpConnectionFactory.class);
    @Nullable
    private final StreamingHttpConnectionFilterFactory connectionFilterFunction;
    final ReadOnlyHttpClientConfig config;
    final HttpExecutionContext executionContext;
    final Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc;
    private final ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection> filterableConnectionFactory;
    private final ProtocolBinding protocolBinding;

    AbstractLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, final HttpExecutionContext executionContext, Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc, final ExecutionStrategy connectStrategy, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, ProtocolBinding protocolBinding) {
        this.connectionFilterFunction = connectionFilterFunction;
        this.config = Objects.requireNonNull(config);
        this.executionContext = Objects.requireNonNull(executionContext);
        this.reqRespFactoryFunc = Objects.requireNonNull(reqRespFactoryFunc);
        Objects.requireNonNull(connectStrategy);
        this.protocolBinding = Objects.requireNonNull(protocolBinding);
        this.filterableConnectionFactory = connectionFactoryFilter.create(new ConnectionFactory<ResolvedAddress, FilterableStreamingHttpConnection>(){
            private final ListenableAsyncCloseable close = AsyncCloseables.emptyAsyncCloseable();

            public Single<FilterableStreamingHttpConnection> newConnection(ResolvedAddress ra, @Nullable ContextMap context, @Nullable TransportObserver observer) {
                Single connection = AbstractLBHttpConnectionFactory.this.newFilterableConnection(Objects.requireNonNull(ra, "Resolved address cannot be null"), observer == null ? NoopTransportObserver.INSTANCE : TransportObservers.asSafeObserver((TransportObserver)observer));
                return connectStrategy instanceof ConnectExecutionStrategy && ((ConnectExecutionStrategy)connectStrategy).isConnectOffloaded() ? connection.publishOn((Executor)executionContext.executor(), IoThreadFactory.IoThread::currentThreadIsIoThread) : connection;
            }

            public Completable onClose() {
                return this.close.onClose();
            }

            public Completable onClosing() {
                return this.close.onClosing();
            }

            public Completable closeAsync() {
                return this.close.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return this.close.closeAsyncGracefully();
            }
        });
    }

    public final Single<FilterableStreamingHttpLoadBalancedConnection> newConnection(ResolvedAddress resolvedAddress, @Nullable ContextMap context, @Nullable TransportObserver observer) {
        return this.filterableConnectionFactory.newConnection(resolvedAddress, context, observer).map(conn -> {
            FilterableStreamingHttpConnection filteredConnection = this.connectionFilterFunction != null ? this.connectionFilterFunction.create(conn) : conn;
            return this.protocolBinding.bind(filteredConnection, this.newConcurrencyController((Publisher<ConsumableEvent<Integer>>)filteredConnection.transportEventStream(AbstractStreamingHttpConnection.MAX_CONCURRENCY_NO_OFFLOADING).beforeOnNext(event -> LOGGER.debug("{} Received {} event: {}", new Object[]{conn, AbstractStreamingHttpConnection.MAX_CONCURRENCY_NO_OFFLOADING, event})), filteredConnection.onClosing()), context);
        });
    }

    abstract Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress var1, TransportObserver var2);

    abstract ReservableRequestConcurrencyController newConcurrencyController(Publisher<? extends ConsumableEvent<Integer>> var1, Completable var2);

    public final Completable onClose() {
        return this.filterableConnectionFactory.onClose();
    }

    public final Completable onClosing() {
        return this.filterableConnectionFactory.onClosing();
    }

    public final Completable closeAsync() {
        return this.filterableConnectionFactory.closeAsync();
    }

    public final Completable closeAsyncGracefully() {
        return this.filterableConnectionFactory.closeAsyncGracefully();
    }

    @FunctionalInterface
    static interface ProtocolBinding {
        public FilterableStreamingHttpLoadBalancedConnection bind(FilterableStreamingHttpConnection var1, ReservableRequestConcurrencyController var2, @Nullable ContextMap var3);
    }
}

