/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.FileRegion;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.transport.netty.internal.WriteDemandEstimator;
import java.util.Objects;

abstract class OverlappingCapacityAwareEstimator
implements WriteDemandEstimator {
    private final SizeEstimator sizeEstimator;
    private long lastSeenCapacity;
    private long outstandingRequested;

    protected OverlappingCapacityAwareEstimator(SizeEstimator sizeEstimator) {
        this.sizeEstimator = Objects.requireNonNull(sizeEstimator);
    }

    @Override
    public final void onItemWrite(Object written, long writeBufferCapacityBeforeWrite, long writeBufferCapacityAfterWrite) {
        long size;
        if (this.outstandingRequested > 0L) {
            --this.outstandingRequested;
        }
        if ((size = this.sizeEstimator.estimateSize(written, writeBufferCapacityBeforeWrite, writeBufferCapacityAfterWrite)) > 0L) {
            this.recordSize(written, size);
        }
    }

    @Override
    public final long estimateRequestN(long writeBufferCapacityInBytes) {
        assert (writeBufferCapacityInBytes >= 0L) : "Write buffer capacity must be non-negative.";
        long capacityToFill = this.outstandingRequested == 0L ? writeBufferCapacityInBytes : writeBufferCapacityInBytes - this.lastSeenCapacity;
        this.lastSeenCapacity = writeBufferCapacityInBytes;
        long toRequest = 0L;
        if (capacityToFill > 0L) {
            toRequest = this.getRequestNForCapacity(capacityToFill);
            if (toRequest == 0L && this.outstandingRequested == 0L) {
                toRequest = 1L;
            }
            this.outstandingRequested = FlowControlUtils.addWithOverflowProtection((long)this.outstandingRequested, (long)toRequest);
        }
        return toRequest;
    }

    protected abstract void recordSize(Object var1, long var2);

    protected abstract long getRequestNForCapacity(long var1);

    @FunctionalInterface
    static interface SizeEstimator {
        public long estimateSize(Object var1, long var2, long var4);

        public static SizeEstimator defaultEstimator() {
            return (written, before, after) -> {
                if (written instanceof FileRegion) {
                    return ((FileRegion)written).count();
                }
                return before > after ? before - after : 0L;
            };
        }
    }
}

