/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.servicetalk.dns.discovery.netty.DnsServerAddressStream;
import io.servicetalk.dns.discovery.netty.DnsServerAddressStreamProvider;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;

public final class SequentialDnsServerAddressStreamProvider
implements DnsServerAddressStreamProvider {
    private final InetSocketAddress[] addresses;

    public SequentialDnsServerAddressStreamProvider(InetSocketAddress ... addresses) {
        if (addresses.length == 0) {
            throw new IllegalArgumentException("addresses must have >0 elements");
        }
        this.addresses = (InetSocketAddress[])addresses.clone();
    }

    public SequentialDnsServerAddressStreamProvider(List<InetSocketAddress> addresses) {
        if (addresses.isEmpty()) {
            throw new IllegalArgumentException("addresses must have >0 elements");
        }
        this.addresses = addresses.toArray(new InetSocketAddress[0]);
    }

    @Override
    public DnsServerAddressStream nameServerAddressStream(String hostname) {
        return new SequentialDnsServerAddressStream(this.addresses);
    }

    private static final class SequentialDnsServerAddressStream
    implements DnsServerAddressStream {
        private final InetSocketAddress[] addresses;
        private int index;

        SequentialDnsServerAddressStream(InetSocketAddress[] addresses) {
            this(addresses, 0);
        }

        SequentialDnsServerAddressStream(InetSocketAddress[] addresses, int index) {
            this.addresses = addresses;
            this.index = index;
        }

        @Override
        public InetSocketAddress next() {
            InetSocketAddress next = this.addresses[this.index++];
            if (this.index == this.addresses.length) {
                this.index = 0;
            }
            return next;
        }

        @Override
        public int size() {
            return this.addresses.length;
        }

        @Override
        public DnsServerAddressStream duplicate() {
            return new SequentialDnsServerAddressStream(this.addresses, this.index);
        }

        public String toString() {
            return "index: " + this.index + " addresses: " + Arrays.toString(this.addresses);
        }
    }
}

