/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentReservationStorage;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class SegmentArchiveSizeStorage {
    private final IgniteLogger log;
    private long walArchiveSize;
    private boolean interrupted;
    private final long minWalArchiveSize;
    private final long maxWalArchiveSize;
    private final boolean walArchiveUnlimited;
    private boolean autoRelease;
    private long lastCpIdx = -1L;
    @Nullable
    private final TreeMap<Long, Long> segmentSizes;
    @Nullable
    private final SegmentReservationStorage reservationStorage;

    public SegmentArchiveSizeStorage(IgniteLogger log, long minWalArchiveSize, long maxWalArchiveSize, SegmentReservationStorage reservationStorage) {
        this.log = log;
        this.minWalArchiveSize = minWalArchiveSize;
        this.maxWalArchiveSize = maxWalArchiveSize;
        if (maxWalArchiveSize != -1L) {
            this.walArchiveUnlimited = false;
            this.segmentSizes = new TreeMap();
            this.reservationStorage = reservationStorage;
        } else {
            this.walArchiveUnlimited = true;
            this.segmentSizes = null;
            this.reservationStorage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeSize(long idx, long sizeChange) {
        T2<Long, Integer> forceReleaseSegments = null;
        SegmentArchiveSizeStorage segmentArchiveSizeStorage = this;
        synchronized (segmentArchiveSizeStorage) {
            this.walArchiveSize += sizeChange;
            if (!this.walArchiveUnlimited) {
                this.segmentSizes.compute(idx, (i, size) -> {
                    long res = (size == null ? 0L : size) + sizeChange;
                    return res == 0L ? null : Long.valueOf(res);
                });
            }
            if (sizeChange > 0L) {
                forceReleaseSegments = this.calcForceReleaseSegments();
                this.notifyAll();
            }
        }
        if (forceReleaseSegments != null) {
            this.forceReleaseSegments((Long)forceReleaseSegments.get1(), (Integer)forceReleaseSegments.get2());
        }
    }

    synchronized void resetSizes() {
        this.walArchiveSize = 0L;
        if (!this.walArchiveUnlimited) {
            this.segmentSizes.clear();
        }
    }

    synchronized void awaitExceedMaxSize(long max) throws IgniteInterruptedCheckedException {
        try {
            while (max - this.walArchiveSize > 0L && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of exceed max archive size");
        }
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    synchronized void reset() {
        this.interrupted = false;
    }

    synchronized long currentSize() {
        return this.walArchiveSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Long segmentSize(long idx) {
        if (this.walArchiveUnlimited) {
            return null;
        }
        SegmentArchiveSizeStorage segmentArchiveSizeStorage = this;
        synchronized (segmentArchiveSizeStorage) {
            return this.segmentSizes.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAutoReleaseSegments() {
        if (!this.walArchiveUnlimited) {
            T2<Long, Integer> forceReleaseSegments;
            SegmentArchiveSizeStorage segmentArchiveSizeStorage = this;
            synchronized (segmentArchiveSizeStorage) {
                this.autoRelease = true;
                forceReleaseSegments = this.calcForceReleaseSegments();
            }
            if (forceReleaseSegments != null) {
                this.forceReleaseSegments((Long)forceReleaseSegments.get1(), (Integer)forceReleaseSegments.get2());
            }
        }
    }

    @Nullable
    private synchronized T2<Long, Integer> calcForceReleaseSegments() {
        if (!this.walArchiveUnlimited && this.autoRelease && this.walArchiveSize >= this.maxWalArchiveSize) {
            long releaseIdx = -1L;
            int releaseCnt = 0;
            long size = 0L;
            for (Map.Entry<Long, Long> e : this.segmentSizes.entrySet()) {
                if (e.getKey() > this.lastCpIdx) break;
                releaseIdx = e.getKey();
                ++releaseCnt;
                if (this.walArchiveSize - (size += e.getValue().longValue()) >= this.minWalArchiveSize) continue;
                break;
            }
            return releaseIdx == -1L ? null : new T2<Long, Integer>(releaseIdx, releaseCnt);
        }
        return null;
    }

    private void forceReleaseSegments(long absIdx, int cnt) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Maximum size of the WAL archive exceeded, the segments will be forcibly released [maxWalArchiveSize=" + U.humanReadableByteCount(this.maxWalArchiveSize) + ", releasedSegmentCnt=" + cnt + ", lastReleasedSegmentIdx=" + absIdx + "]");
        }
        this.reservationStorage.forceRelease(absIdx);
    }

    synchronized void lastCheckpointIdx(long absIdx) {
        this.lastCpIdx = absIdx;
    }
}

