/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlConvertFunction;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public class SqlOracleConvertFunction
extends SqlConvertFunction {
    public SqlOracleConvertFunction(String name) {
        super(name, SqlKind.CONVERT_ORACLE, ReturnTypes.ARG0, null, null, SqlFunctionCategory.STRING);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        operands.get(0).validateExpr(validator, scope);
        assert (operands.get(1) instanceof SqlIdentifier);
        String src_charset = operands.get(1).toString();
        SqlUtil.getCharset(src_charset);
        if (operands.size() == 3) {
            assert (operands.get(2) instanceof SqlIdentifier);
            String dest_charset = operands.get(2).toString();
            SqlUtil.getCharset(dest_charset);
        }
        super.validateQuantifier(validator, call);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = opBinding.getOperandType(0);
        if (SqlTypeUtil.isNull(ret)) {
            return ret;
        }
        String descCharsetName = opBinding instanceof SqlCallBinding ? ((SqlNode)((SqlCallBinding)opBinding).getCall().operand(1)).toString() : ((RexCallBinding)opBinding).getStringLiteralOperand(1);
        assert (descCharsetName != null);
        Charset descCharset = SqlUtil.getCharset(descCharsetName);
        return opBinding.getTypeFactory().createTypeWithCharsetAndCollation(ret, descCharset, NonNullableAccessors.getCollation(ret));
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope, (SqlNode)call.operand(0));
        Objects.requireNonNull(nodeType, "nodeType");
        RelDataType ret = this.validateOperands(validator, scope, call);
        if (SqlTypeUtil.isNull(ret)) {
            return ret;
        }
        Charset descCharset = SqlUtil.getCharset(((SqlNode)call.operand(1)).toString());
        return validator.getTypeFactory().createTypeWithCharsetAndCollation(ret, descCharset, NonNullableAccessors.getCollation(ret));
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1}, {2})";
            }
            case 3: {
                return "{0}({1}, {2}, {3})";
            }
        }
        throw new IllegalStateException("operandsCount should be 2 or 3, got " + operandsCount);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }
}

