/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot.remote;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.core.Scheduler;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.option.CopyOptions;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.rpc.GetFileRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftClientService;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosureAdapter;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.snapshot.remote.Session;
import org.apache.ignite.raft.jraft.util.ByteBufferCollector;
import org.apache.ignite.raft.jraft.util.BytesUtil;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.Utils;

public class CopySession
implements Session {
    private static final IgniteLogger LOG = Loggers.forClass(CopySession.class);
    private final Lock lock = new ReentrantLock();
    private final Status st = Status.OK();
    private final CountDownLatch finishLatch = new CountDownLatch(1);
    private final GetFileResponseClosure done = new GetFileResponseClosure();
    private final RaftClientService rpcService;
    private final GetFileRequestBuilder requestBuilder;
    private final PeerId peerId;
    private final Scheduler timerManager;
    private final SnapshotThrottle snapshotThrottle;
    private final RaftOptions raftOptions;
    private int retryTimes = 0;
    private boolean finished;
    private ByteBufferCollector destBuf;
    private CopyOptions copyOptions = new CopyOptions();
    private OutputStream outputStream;
    private ScheduledFuture<?> timer;
    private String destPath;
    private Future<Message> rpcCall;
    private NodeOptions nodeOptions;

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @OnlyForTest
    GetFileResponseClosure getDone() {
        return this.done;
    }

    @OnlyForTest
    Future<Message> getRpcCall() {
        return this.rpcCall;
    }

    @OnlyForTest
    ScheduledFuture<?> getTimer() {
        return this.timer;
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (!this.finished) {
                Utils.closeQuietly(this.outputStream);
            }
            if (null != this.destBuf) {
                this.destBuf.recycle();
                this.destBuf = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public CopySession(RaftClientService rpcService, Scheduler timerManager, SnapshotThrottle snapshotThrottle, RaftOptions raftOptions, NodeOptions nodeOptions, GetFileRequestBuilder rb, PeerId peerId) {
        this.snapshotThrottle = snapshotThrottle;
        this.raftOptions = raftOptions;
        this.timerManager = timerManager;
        this.rpcService = rpcService;
        this.requestBuilder = rb;
        this.peerId = peerId;
        this.nodeOptions = nodeOptions;
    }

    public void setDestBuf(ByteBufferCollector bufRef) {
        this.destBuf = bufRef;
    }

    public void setCopyOptions(CopyOptions copyOptions) {
        this.copyOptions = copyOptions;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    @Override
    public void cancel() {
        this.lock.lock();
        try {
            if (this.finished) {
                return;
            }
            if (this.timer != null) {
                this.timer.cancel(true);
            }
            if (this.rpcCall != null) {
                this.rpcCall.cancel(true);
            }
            if (this.st.isOk()) {
                this.st.setError(RaftError.ECANCELED, RaftError.ECANCELED.name(), new Object[0]);
            }
            this.onFinished();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.finishLatch.await();
    }

    @Override
    public Status status() {
        return this.st;
    }

    private void onFinished() {
        if (!this.finished) {
            if (!this.st.isOk()) {
                LOG.error("Fail to copy data, readerId={} fileName={} offset={} status={}", new Object[]{this.requestBuilder.readerId(), this.requestBuilder.filename(), this.requestBuilder.offset(), this.st});
            }
            if (this.outputStream != null) {
                Utils.closeQuietly(this.outputStream);
                this.outputStream = null;
            }
            if (this.destBuf != null) {
                ByteBuffer buf = this.destBuf.getBuffer();
                if (buf != null) {
                    buf.flip();
                }
                this.destBuf = null;
            }
            this.finished = true;
            this.finishLatch.countDown();
        }
    }

    private void onTimer() {
        Utils.runInThread(this.nodeOptions.getCommonExecutor(), this::sendNextRpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRpcReturned(Status status, RpcRequests.GetFileResponse response) {
        this.lock.lock();
        try {
            if (this.finished) {
                return;
            }
            if (!status.isOk()) {
                this.requestBuilder.count(0L);
                if (status.getCode() == RaftError.ECANCELED.getNumber() && this.st.isOk()) {
                    this.st.setError(status.getCode(), status.getErrorMsg(), new Object[0]);
                    this.onFinished();
                    return;
                }
                if (status.getCode() != RaftError.EAGAIN.getNumber() && ++this.retryTimes >= this.copyOptions.getMaxRetry() && this.st.isOk()) {
                    this.st.setError(status.getCode(), status.getErrorMsg(), new Object[0]);
                    this.onFinished();
                    return;
                }
                this.timer = this.timerManager.schedule(this::onTimer, this.copyOptions.getRetryIntervalMs(), TimeUnit.MILLISECONDS);
                return;
            }
            this.retryTimes = 0;
            Requires.requireNonNull(response, "response");
            if (!response.eof()) {
                this.requestBuilder.count(response.readSize());
            }
            if (this.outputStream != null) {
                try {
                    BytesUtil.writeTo(this.outputStream, response.data());
                }
                catch (IOException e) {
                    LOG.error("Fail to write into file {}", new Object[]{this.destPath, e});
                    this.st.setError(RaftError.EIO, RaftError.EIO.name(), new Object[0]);
                    this.onFinished();
                    this.lock.unlock();
                    return;
                }
            } else {
                this.destBuf.put(response.data().asReadOnlyBuffer());
            }
            if (response.eof()) {
                this.onFinished();
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.sendNextRpc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNextRpc() {
        this.lock.lock();
        try {
            this.timer = null;
            long offset = this.requestBuilder.offset() + this.requestBuilder.count();
            long maxCount = this.destBuf == null ? (long)this.raftOptions.getMaxByteCountPerRpc() : Integer.MAX_VALUE;
            this.requestBuilder.offset(offset).count(maxCount).readPartly(true);
            if (this.finished) {
                return;
            }
            long newMaxCount = maxCount;
            if (this.snapshotThrottle != null && (newMaxCount = this.snapshotThrottle.throttledByThroughput(maxCount)) == 0L) {
                this.requestBuilder.count(0L);
                this.timer = this.timerManager.schedule(this::onTimer, this.copyOptions.getRetryIntervalMs(), TimeUnit.MILLISECONDS);
                return;
            }
            this.requestBuilder.count(newMaxCount);
            RpcRequests.GetFileRequest request = this.requestBuilder.build();
            LOG.debug("Send get file request {} to peer {}", new Object[]{request, this.peerId});
            this.rpcCall = this.rpcService.getFile(this.peerId, request, this.copyOptions.getTimeoutMs(), this.done);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class GetFileResponseClosure
    extends RpcResponseClosureAdapter<RpcRequests.GetFileResponse> {
        private GetFileResponseClosure() {
        }

        @Override
        public void run(Status status) {
            CopySession.this.onRpcReturned(status, (RpcRequests.GetFileResponse)this.getResponse());
        }
    }
}

