/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rule.ImmutableSortMergeRule;
import org.immutables.value.Value;

@Value.Enclosing
public class SortMergeRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.INSTANCE.toRule();

    private SortMergeRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteSort topSort = (IgniteSort)call.rel(0);
        IgniteSort bottomSort = (IgniteSort)call.rel(1);
        if (bottomSort.isEnforcer() && !topSort.isEnforcer()) {
            topSort.getCluster().getPlanner().prune((RelNode)bottomSort);
            return;
        }
        if (!bottomSort.isEnforcer() && topSort.isEnforcer() && topSort.collation.satisfies((RelTrait)bottomSort.collation)) {
            topSort.getCluster().getPlanner().prune((RelNode)topSort);
            call.transformTo((RelNode)new IgniteSort(topSort.getCluster(), topSort.getTraitSet(), bottomSort.getInput(), topSort.collation, bottomSort.offset, bottomSort.fetch));
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = (Config)ImmutableSortMergeRule.Config.of().withDescription("SortMergeRule").withOperandSupplier(o0 -> o0.operand(IgniteSort.class).oneInput(o1 -> o1.operand(IgniteSort.class).anyInputs())).as(Config.class);

        default public SortMergeRule toRule() {
            return new SortMergeRule(this);
        }
    }
}

