/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class TopologyTracker {
    private static final IgniteLogger LOG = Loggers.forClass(TopologyTracker.class);
    private final LogicalTopologyService topologyService;
    private AtomicReference<LogicalTopologySnapshot> topologySnapRef;
    private final TopologyListener topologyListener;

    public TopologyTracker(LogicalTopologyService topologyService) {
        this.topologyService = topologyService;
        this.topologySnapRef = new AtomicReference();
        this.topologyListener = new TopologyListener();
    }

    public void startTrack() {
        this.topologyService.addEventListener((LogicalTopologyEventListener)this.topologyListener);
        this.topologyService.logicalTopologyOnLeader().thenAccept(topologySnap -> {
            LogicalTopologySnapshot logicalTopologySnap0;
            while (!((logicalTopologySnap0 = this.topologySnapRef.get()) != null && logicalTopologySnap0.version() >= topologySnap.version() || this.topologySnapRef.compareAndSet(logicalTopologySnap0, (LogicalTopologySnapshot)topologySnap))) {
            }
            LOG.info("Logical topology initialized for placement driver [topologySnap={}]", new Object[]{topologySnap});
        });
    }

    public void stopTrack() {
        this.topologyService.removeEventListener((LogicalTopologyEventListener)this.topologyListener);
    }

    @Nullable
    public InternalClusterNode nodeByConsistentId(String consistentId) {
        LogicalTopologySnapshot logicalTopologySnap0 = this.topologySnapRef.get();
        if (logicalTopologySnap0 == null || CollectionUtils.nullOrEmpty((Collection)logicalTopologySnap0.nodes())) {
            return null;
        }
        for (LogicalNode node : logicalTopologySnap0.nodes()) {
            if (!node.name().equals(consistentId)) continue;
            return node;
        }
        return null;
    }

    LogicalTopologySnapshot currentTopologySnapshot() {
        return this.topologySnapRef.get();
    }

    private class TopologyListener
    implements LogicalTopologyEventListener {
        private TopologyListener() {
        }

        public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
            this.onUpdate(newTopology);
        }

        public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
            this.onUpdate(newTopology);
        }

        public void onTopologyLeap(LogicalTopologySnapshot newTopology) {
            this.onUpdate(newTopology);
        }

        public void onUpdate(LogicalTopologySnapshot topologySnap) {
            LogicalTopologySnapshot logicalTopologySnap0;
            while (!((logicalTopologySnap0 = TopologyTracker.this.topologySnapRef.get()) != null && logicalTopologySnap0.version() >= topologySnap.version() || TopologyTracker.this.topologySnapRef.compareAndSet(logicalTopologySnap0, topologySnap))) {
            }
            LOG.debug("Logical topology updated for placement driver [topologySnap={}]", new Object[]{topologySnap});
        }
    }
}

