/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.treesitter.highlighter;

import java.util.Map;
import org.apache.ignite.internal.cli.commands.treesitter.parser.Indexer;
import org.apache.ignite.internal.cli.commands.treesitter.parser.Parser;
import org.apache.ignite.internal.cli.commands.treesitter.parser.SqlTokenType;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.treesitter.TSTree;

public class SqlAttributedStringHighlighter {
    private static final Map<SqlTokenType, Integer> colorMap = Map.of(SqlTokenType.KEYWORD, 215, SqlTokenType.IDENTIFIER, 254, SqlTokenType.BRACKET, 248, SqlTokenType.LITERAL, 106, SqlTokenType.SPACE, 0, SqlTokenType.COMMA, 248, SqlTokenType.EQUAL, 248, SqlTokenType.STAR, 248, SqlTokenType.SEMICOLON, 248, SqlTokenType.UNKNOWN, 248);

    public static AttributedString highlight(String text) {
        AttributedStringBuilder as = new AttributedStringBuilder();
        TSTree tree = Parser.parseSql(text);
        SqlTokenType[] tokens = Indexer.indexSql(text, tree);
        for (int i = 0; i < text.length(); ++i) {
            SqlTokenType token = tokens[i];
            int color = colorMap.getOrDefault((Object)token, 1);
            AttributedStyle style = AttributedStyle.DEFAULT.foreground(color);
            as.style(style).append(text.charAt(i));
        }
        return as.toAttributedString();
    }
}

