/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.configuration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.util.IgniteUtils;

public final class ValueSerializationHelper {
    public static String toString(Object defaultValue, NativeType type) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Objects.requireNonNull(type, "type");
        switch (type.spec()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: 
            case NUMBER: 
            case STRING: 
            case UUID: {
                return defaultValue.toString();
            }
            case BYTES: {
                return IgniteUtils.toHexString((byte[])((byte[])defaultValue));
            }
            case BITMASK: {
                return IgniteUtils.toHexString((byte[])((BitSet)defaultValue).toByteArray());
            }
        }
        throw new IllegalStateException("Unknown type [type=" + type + "]");
    }

    public static Object fromString(String defaultValue, NativeType type) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Objects.requireNonNull(type, "type");
        switch (type.spec()) {
            case INT8: {
                return Byte.parseByte(defaultValue);
            }
            case INT16: {
                return Short.parseShort(defaultValue);
            }
            case INT32: {
                return Integer.parseInt(defaultValue);
            }
            case INT64: {
                return Long.parseLong(defaultValue);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(defaultValue));
            }
            case DOUBLE: {
                return Double.parseDouble(defaultValue);
            }
            case DECIMAL: {
                assert (type instanceof DecimalNativeType);
                return new BigDecimal(defaultValue).setScale(((DecimalNativeType)type).scale(), RoundingMode.HALF_UP);
            }
            case DATE: {
                return LocalDate.parse(defaultValue);
            }
            case TIME: {
                return LocalTime.parse(defaultValue);
            }
            case DATETIME: {
                return LocalDateTime.parse(defaultValue);
            }
            case TIMESTAMP: {
                return Instant.parse(defaultValue);
            }
            case NUMBER: {
                return new BigInteger(defaultValue);
            }
            case STRING: {
                return defaultValue;
            }
            case UUID: {
                return UUID.fromString(defaultValue);
            }
            case BYTES: {
                return IgniteUtils.fromHexString((String)defaultValue);
            }
            case BITMASK: {
                return BitSet.valueOf(IgniteUtils.fromHexString((String)defaultValue));
            }
        }
        throw new IllegalStateException("Unknown type [type=" + type + "]");
    }

    private ValueSerializationHelper() {
    }
}

