/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb.flush;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlushListener;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDbFlusher {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbFlusher.class);
    private volatile RocksDB db;
    private final List<ColumnFamilyHandle> columnFamilyHandles = new ArrayList<ColumnFamilyHandle>();
    private final Object columnFamilyHandlesMux = new Object();
    private final ScheduledExecutorService scheduledPool;
    final ExecutorService threadPool;
    private final IntSupplier delaySupplier;
    private final Runnable onFlushCompleted;
    private final FlushOptions flushOptions = new FlushOptions().setWaitForFlush(false);
    private final SortedMap<Long, CompletableFuture<Void>> flushFuturesBySequenceNumber = new ConcurrentSkipListMap<Long, CompletableFuture<Void>>();
    private long latestPersistedSequenceNumber;
    private final Object latestPersistedSequenceNumberMux = new Object();
    private final IgniteSpinBusyLock busyLock;
    private volatile Runnable latestFlushClosure;

    public RocksDbFlusher(IgniteSpinBusyLock busyLock, ScheduledExecutorService scheduledPool, ExecutorService threadPool, IntSupplier delaySupplier, Runnable onFlushCompleted) {
        this.busyLock = busyLock;
        this.scheduledPool = scheduledPool;
        this.threadPool = threadPool;
        this.delaySupplier = delaySupplier;
        this.onFlushCompleted = onFlushCompleted;
    }

    public AbstractEventListener listener() {
        return new RocksDbFlushListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(RocksDB db, List<ColumnFamilyHandle> columnFamilyHandles) {
        this.db = db;
        Object object = this.columnFamilyHandlesMux;
        synchronized (object) {
            this.columnFamilyHandles.addAll(columnFamilyHandles);
        }
        object = this.latestPersistedSequenceNumberMux;
        synchronized (object) {
            this.latestPersistedSequenceNumber = db.getLatestSequenceNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumnFamily(ColumnFamilyHandle handle) {
        Object object = this.columnFamilyHandlesMux;
        synchronized (object) {
            this.columnFamilyHandles.add(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumnFamily(ColumnFamilyHandle handle) {
        Object object = this.columnFamilyHandlesMux;
        synchronized (object) {
            this.columnFamilyHandles.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> awaitFlush(boolean schedule) {
        CompletableFuture future;
        long dbSequenceNumber = this.db.getLatestSequenceNumber();
        Object object = this.latestPersistedSequenceNumberMux;
        synchronized (object) {
            if (dbSequenceNumber <= this.latestPersistedSequenceNumber) {
                return CompletableFuture.completedFuture(null);
            }
            future = this.flushFuturesBySequenceNumber.computeIfAbsent(dbSequenceNumber, s -> new CompletableFuture());
        }
        if (schedule) {
            this.scheduleFlush();
        }
        return future;
    }

    private void scheduleFlush() {
        Runnable newClosure;
        this.latestFlushClosure = newClosure = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (RocksDbFlusher.this.latestFlushClosure != this) {
                    return;
                }
                if (!RocksDbFlusher.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    Object object = RocksDbFlusher.this.columnFamilyHandlesMux;
                    synchronized (object) {
                        RocksDbFlusher.this.db.flush(RocksDbFlusher.this.flushOptions, RocksDbFlusher.this.columnFamilyHandles);
                    }
                }
                catch (RocksDBException e) {
                    LOG.error("Error occurred during the explicit flush", (Throwable)e);
                }
                finally {
                    RocksDbFlusher.this.busyLock.leaveBusy();
                }
            }
        };
        this.scheduledPool.schedule(newClosure, (long)this.delaySupplier.getAsInt(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeFutures(long sequenceNumber) {
        Object object = this.latestPersistedSequenceNumberMux;
        synchronized (object) {
            if (sequenceNumber <= this.latestPersistedSequenceNumber) {
                return;
            }
            this.latestPersistedSequenceNumber = sequenceNumber;
        }
        SortedMap<Long, CompletableFuture<Void>> futuresToComplete = this.flushFuturesBySequenceNumber.headMap(sequenceNumber + 1L);
        for (CompletableFuture<Void> future : futuresToComplete.values()) {
            future.complete(null);
        }
        futuresToComplete.clear();
    }

    public void stop() {
        for (CompletableFuture<Void> future : this.flushFuturesBySequenceNumber.values()) {
            future.cancel(false);
        }
        this.flushOptions.close();
    }

    CompletableFuture<Void> onFlushCompleted() {
        return CompletableFuture.runAsync(this.onFlushCompleted, this.threadPool);
    }
}

