/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.ClusterTagBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClusterTagImpl
implements ClusterTag {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 62;
    @IgniteToStringInclude
    private final UUID clusterId;
    @IgniteToStringInclude
    private final String clusterName;

    private ClusterTagImpl(UUID clusterId, String clusterName) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
    }

    @Override
    public UUID clusterId() {
        return this.clusterId;
    }

    @Override
    public String clusterName() {
        return this.clusterName;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterTagImpl.class, (Object)this);
    }

    public short messageType() {
        return 62;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterTagImpl otherMessage = (ClusterTagImpl)other;
        return Objects.equals(this.clusterId, otherMessage.clusterId) && Objects.equals(this.clusterName, otherMessage.clusterName);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterId, this.clusterName);
        return result;
    }

    public static ClusterTagBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ClusterTagBuilder {
        private UUID clusterId;
        private String clusterName;

        private Builder() {
        }

        @Override
        public ClusterTagBuilder clusterId(UUID clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ClusterTagBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        @Override
        public UUID clusterId() {
            return this.clusterId;
        }

        @Override
        public String clusterName() {
            return this.clusterName;
        }

        @Override
        public ClusterTag build() {
            return new ClusterTagImpl(this.clusterId, this.clusterName);
        }
    }
}

