/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.client.Condition;
import org.apache.ignite.internal.metastorage.client.Entry;
import org.apache.ignite.internal.metastorage.client.If;
import org.apache.ignite.internal.metastorage.client.MetaStorageService;
import org.apache.ignite.internal.metastorage.client.MetaStorageServiceImpl;
import org.apache.ignite.internal.metastorage.client.Operation;
import org.apache.ignite.internal.metastorage.client.StatementResult;
import org.apache.ignite.internal.metastorage.client.WatchListener;
import org.apache.ignite.internal.metastorage.common.MetaStorageException;
import org.apache.ignite.internal.metastorage.common.MetastorageGroupId;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.raft.MetaStorageListener;
import org.apache.ignite.internal.metastorage.watch.AggregatedWatch;
import org.apache.ignite.internal.metastorage.watch.KeyCriterion;
import org.apache.ignite.internal.metastorage.watch.WatchAggregator;
import org.apache.ignite.internal.raft.Loza;
import org.apache.ignite.internal.raft.server.RaftGroupOptions;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.network.util.ClusterServiceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaStorageManager
implements IgniteComponent {
    public static final ByteArray APPLIED_REV = ByteArray.fromString((String)"applied_revision");
    private final ClusterService clusterService;
    private final VaultManager vaultMgr;
    private final Loza raftMgr;
    private final ClusterManagementGroupManager cmgMgr;
    private volatile CompletableFuture<MetaStorageService> metaStorageSvcFut;
    private final WatchAggregator watchAggregator = new WatchAggregator();
    private CompletableFuture<IgniteUuid> deployFut = new CompletableFuture();
    private final KeyValueStorage storage;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private boolean areWatchesDeployed = false;
    private volatile boolean isInitialized = false;
    private final AtomicBoolean isStopped = new AtomicBoolean();

    public MetaStorageManager(VaultManager vaultMgr, ClusterService clusterService, ClusterManagementGroupManager cmgMgr, Loza raftMgr, KeyValueStorage storage) {
        this.vaultMgr = vaultMgr;
        this.clusterService = clusterService;
        this.raftMgr = raftMgr;
        this.cmgMgr = cmgMgr;
        this.storage = storage;
    }

    private CompletableFuture<MetaStorageService> initializeMetaStorage(Collection<String> metaStorageNodes) {
        ClusterNode thisNode;
        List metastorageNodes = ClusterServiceUtils.resolveNodes((ClusterService)this.clusterService, metaStorageNodes);
        if (metastorageNodes.contains(thisNode = this.clusterService.topologyService().localMember())) {
            this.clusterService.topologyService().addEventHandler(new TopologyEventHandler(){

                public void onDisappeared(ClusterNode member) {
                    MetaStorageManager.this.metaStorageSvcFut.thenAccept(svc -> svc.closeCursors(member.id()));
                }
            });
        }
        this.storage.start();
        try {
            CompletableFuture raftServiceFuture = this.raftMgr.prepareRaftGroup((ReplicationGroupId)MetastorageGroupId.INSTANCE, metastorageNodes, () -> new MetaStorageListener(this.storage), RaftGroupOptions.defaults());
            return raftServiceFuture.thenApply(service -> new MetaStorageServiceImpl(service, thisNode.id(), thisNode.name()));
        }
        catch (NodeStoppingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public void start() {
        this.metaStorageSvcFut = this.cmgMgr.metaStorageNodes().thenComposeAsync(metaStorageNodes -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture(new NodeStoppingException());
            }
            try {
                this.isInitialized = true;
                CompletableFuture<MetaStorageService> completableFuture = this.initializeMetaStorage((Collection<String>)metaStorageNodes);
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.isStopped.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        if (!this.isInitialized) {
            return;
        }
        MetaStorageManager metaStorageManager = this;
        synchronized (metaStorageManager) {
            IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this::stopDeployedWatches, () -> this.raftMgr.stopRaftGroup((ReplicationGroupId)MetastorageGroupId.INSTANCE), this.storage});
        }
    }

    private void stopDeployedWatches() throws Exception {
        if (!this.areWatchesDeployed) {
            return;
        }
        ((CompletableFuture)this.deployFut.thenCompose(watchId -> watchId == null ? CompletableFuture.completedFuture(null) : this.metaStorageSvcFut.thenAccept(service -> service.stopWatch(watchId)))).get();
    }

    public synchronized void deployWatches() throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CompletableFuture<IgniteUuid> deployFut = this.deployFut;
            this.updateAggregatedWatch().whenComplete((id, ex) -> {
                if (ex == null) {
                    deployFut.complete((IgniteUuid)id);
                } else {
                    deployFut.completeExceptionally((Throwable)ex);
                }
            });
            this.areWatchesDeployed = true;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Long> registerWatch(ByteArray key, WatchListener lsnr) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            long watchId = this.watchAggregator.add(key, lsnr);
            CompletionStage completionStage = this.updateWatches().thenApply(uuid -> watchId);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Long> registerWatch(Collection<ByteArray> keys, WatchListener lsnr) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            long watchId = this.watchAggregator.add(keys, lsnr);
            CompletionStage completionStage = this.updateWatches().thenApply(uuid -> watchId);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Long> registerWatch(@NotNull ByteArray from, @NotNull ByteArray to, @NotNull WatchListener lsnr) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            long watchId = this.watchAggregator.add(from, to, lsnr);
            CompletionStage completionStage = this.updateWatches().thenApply(uuid -> watchId);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Long> registerWatchByPrefix(ByteArray key, WatchListener lsnr) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            long watchId = this.watchAggregator.addPrefix(key, lsnr);
            CompletionStage completionStage = this.updateWatches().thenApply(uuid -> watchId);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Void> unregisterWatch(long id) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            this.watchAggregator.cancel(id);
            CompletionStage completionStage = this.updateWatches().thenApply(uuid -> null);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Entry> get(@NotNull ByteArray key) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.get(key));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Entry> get(@NotNull ByteArray key, long revUpperBound) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.get(key, revUpperBound));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Map<ByteArray, Entry>> getAll(Set<ByteArray> keys) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.getAll(keys));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Map<ByteArray, Entry>> getAll(Set<ByteArray> keys, long revUpperBound) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.getAll(keys, revUpperBound));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> put(@NotNull ByteArray key, byte[] val) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.put(key, val));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Entry> getAndPut(@NotNull ByteArray key, byte[] val) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.getAndPut(key, val));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Void> putAll(@NotNull Map<ByteArray, byte[]> vals) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.putAll(vals));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Map<ByteArray, Entry>> getAndPutAll(@NotNull Map<ByteArray, byte[]> vals) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.getAndPutAll(vals));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Void> remove(@NotNull ByteArray key) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.remove(key));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Entry> getAndRemove(@NotNull ByteArray key) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.getAndRemove(key));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Void> removeAll(@NotNull Set<ByteArray> keys) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.removeAll(keys));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Map<ByteArray, Entry>> getAndRemoveAll(@NotNull Set<ByteArray> keys) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.getAndRemoveAll(keys));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Boolean> invoke(@NotNull Condition cond, @NotNull Operation success, @NotNull Operation failure) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.invoke(cond, success, failure));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Boolean> invoke(@NotNull Condition cond, @NotNull Collection<Operation> success, @NotNull Collection<Operation> failure) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.invoke(cond, success, failure));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<StatementResult> invoke(@NotNull If iif) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(svc -> svc.invoke(iif));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Cursor<Entry> range(@NotNull ByteArray keyFrom, @Nullable ByteArray keyTo, long revUpperBound) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CursorWrapper<Entry> cursorWrapper = new CursorWrapper<Entry>((CompletableFuture<Cursor<Entry>>)this.metaStorageSvcFut.thenApply(svc -> svc.range(keyFrom, keyTo, revUpperBound)));
            return cursorWrapper;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public Cursor<Entry> range(@NotNull ByteArray keyFrom, @Nullable ByteArray keyTo) throws NodeStoppingException {
        return this.range(keyFrom, keyTo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Cursor<Entry> range(@NotNull ByteArray keyFrom, @Nullable ByteArray keyTo, boolean includeTombstones) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CursorWrapper<Entry> cursorWrapper = new CursorWrapper<Entry>((CompletableFuture<Cursor<Entry>>)this.metaStorageSvcFut.thenApply(svc -> svc.range(keyFrom, keyTo, includeTombstones)));
            return cursorWrapper;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Cursor<Entry> rangeWithAppliedRevision(@NotNull ByteArray keyFrom, @Nullable ByteArray keyTo) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CompletionStage cursorFuture = this.metaStorageSvcFut.thenCombine(this.appliedRevision(), (svc, appliedRevision) -> svc.range(keyFrom, keyTo, appliedRevision.longValue()));
            CursorWrapper<Entry> cursorWrapper = new CursorWrapper<Entry>((CompletableFuture<Cursor<Entry>>)cursorFuture);
            return cursorWrapper;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Cursor<Entry> prefixWithAppliedRevision(@NotNull ByteArray keyPrefix) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            KeyCriterion.RangeCriterion rangeCriterion = KeyCriterion.RangeCriterion.fromPrefixKey(keyPrefix);
            CompletionStage cursorFuture = this.metaStorageSvcFut.thenCombine(this.appliedRevision(), (svc, appliedRevision) -> svc.range(rangeCriterion.from(), rangeCriterion.to(), appliedRevision.longValue()));
            CursorWrapper<Entry> cursorWrapper = new CursorWrapper<Entry>((CompletableFuture<Cursor<Entry>>)cursorFuture);
            return cursorWrapper;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public Cursor<Entry> prefix(@NotNull ByteArray keyPrefix) throws NodeStoppingException {
        return this.prefix(keyPrefix, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Cursor<Entry> prefix(@NotNull ByteArray keyPrefix, long revUpperBound) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            KeyCriterion.RangeCriterion rangeCriterion = KeyCriterion.RangeCriterion.fromPrefixKey(keyPrefix);
            CursorWrapper<Entry> cursorWrapper = new CursorWrapper<Entry>((CompletableFuture<Cursor<Entry>>)this.metaStorageSvcFut.thenApply(svc -> svc.range(rangeCriterion.from(), rangeCriterion.to(), revUpperBound)));
            return cursorWrapper;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @NotNull
    public CompletableFuture<Void> compact() {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.metaStorageSvcFut.thenCompose(MetaStorageService::compact);
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Long> appliedRevision() {
        return this.vaultMgr.get(APPLIED_REV).thenApply(appliedRevision -> appliedRevision == null ? 0L : ByteUtils.bytesToLong((byte[])appliedRevision.value()));
    }

    private CompletableFuture<IgniteUuid> updateWatches() {
        if (!this.areWatchesDeployed) {
            return this.deployFut;
        }
        this.deployFut = ((CompletableFuture)this.deployFut.thenCompose(id -> id == null ? CompletableFuture.completedFuture(null) : this.metaStorageSvcFut.thenCompose(svc -> svc.stopWatch(id)))).thenCompose(r -> this.updateAggregatedWatch());
        return this.deployFut;
    }

    private CompletableFuture<IgniteUuid> updateAggregatedWatch() {
        return this.appliedRevision().thenCompose(appliedRevision -> this.watchAggregator.watch(appliedRevision + 1L, this::storeEntries).map(this::dispatchAppropriateMetaStorageWatch).orElseGet(() -> CompletableFuture.completedFuture(null)));
    }

    private void storeEntries(Collection<IgniteBiTuple<ByteArray, byte[]>> entries, long revision) {
        ((CompletableFuture)this.appliedRevision().thenCompose(appliedRevision -> {
            if (revision <= appliedRevision) {
                throw new MetaStorageException(ErrorGroups.MetaStorage.DEPLOYING_WATCH_ERR, String.format("Current revision (%d) must be greater than the revision in the Vault (%d)", revision, appliedRevision));
            }
            HashMap batch = IgniteUtils.newHashMap((int)(entries.size() + 1));
            batch.put(APPLIED_REV, ByteUtils.longToBytes((long)revision));
            entries.forEach(e -> batch.put((ByteArray)e.getKey(), (byte[])e.getValue()));
            return this.vaultMgr.putAll((Map)batch);
        })).join();
    }

    private CompletableFuture<IgniteUuid> dispatchAppropriateMetaStorageWatch(AggregatedWatch aggregatedWatch) {
        if (aggregatedWatch.keyCriterion() instanceof KeyCriterion.CollectionCriterion) {
            KeyCriterion.CollectionCriterion criterion = (KeyCriterion.CollectionCriterion)aggregatedWatch.keyCriterion();
            return this.metaStorageSvcFut.thenCompose(metaStorageSvc -> metaStorageSvc.watch(criterion.keys(), aggregatedWatch.revision(), aggregatedWatch.listener()));
        }
        if (aggregatedWatch.keyCriterion() instanceof KeyCriterion.ExactCriterion) {
            KeyCriterion.ExactCriterion criterion = (KeyCriterion.ExactCriterion)aggregatedWatch.keyCriterion();
            return this.metaStorageSvcFut.thenCompose(metaStorageSvc -> metaStorageSvc.watch(criterion.key(), aggregatedWatch.revision(), aggregatedWatch.listener()));
        }
        if (aggregatedWatch.keyCriterion() instanceof KeyCriterion.RangeCriterion) {
            KeyCriterion.RangeCriterion criterion = (KeyCriterion.RangeCriterion)aggregatedWatch.keyCriterion();
            return this.metaStorageSvcFut.thenCompose(metaStorageSvc -> metaStorageSvc.watch(criterion.from(), criterion.to(), aggregatedWatch.revision(), aggregatedWatch.listener()));
        }
        throw new UnsupportedOperationException("Unsupported type of criterion");
    }

    private final class CursorWrapper<T>
    implements Cursor<T> {
        private final CompletableFuture<Cursor<T>> innerCursorFut;
        private final CompletableFuture<Iterator<T>> innerIterFut;

        CursorWrapper(CompletableFuture<Cursor<T>> innerCursorFut) {
            this.innerCursorFut = innerCursorFut;
            this.innerIterFut = innerCursorFut.thenApply(Iterable::iterator);
        }

        public void close() throws Exception {
            if (!MetaStorageManager.this.busyLock.enterBusy()) {
                throw new NodeStoppingException();
            }
            try {
                ((CompletableFuture)this.innerCursorFut.thenAccept(cursor -> {
                    try {
                        cursor.close();
                    }
                    catch (Exception e) {
                        throw new MetaStorageException(ErrorGroups.MetaStorage.CURSOR_CLOSING_ERR, (Throwable)e);
                    }
                })).get();
            }
            finally {
                MetaStorageManager.this.busyLock.leaveBusy();
            }
        }

        public boolean hasNext() {
            if (!MetaStorageManager.this.busyLock.enterBusy()) {
                return false;
            }
            try {
                boolean bl = (Boolean)((CompletableFuture)this.innerIterFut.thenApply(Iterator::hasNext)).get();
                return bl;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new MetaStorageException(ErrorGroups.MetaStorage.CURSOR_EXECUTION_ERR, (Throwable)e);
            }
            finally {
                MetaStorageManager.this.busyLock.leaveBusy();
            }
        }

        public T next() {
            if (!MetaStorageManager.this.busyLock.enterBusy()) {
                throw new NoSuchElementException("No such element because node is stopping.");
            }
            try {
                Object t = ((CompletableFuture)this.innerIterFut.thenApply(Iterator::next)).get();
                return t;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new MetaStorageException(ErrorGroups.MetaStorage.CURSOR_EXECUTION_ERR, (Throwable)e);
            }
            finally {
                MetaStorageManager.this.busyLock.leaveBusy();
            }
        }
    }
}

