/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table.mapper;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.MapperBuilder;
import org.apache.ignite.table.mapper.OneColumnMapperImpl;
import org.apache.ignite.table.mapper.TypeConverter;
import org.jetbrains.annotations.NotNull;

public interface Mapper<T> {
    public static <O> Mapper<O> of(@NotNull Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            return new OneColumnMapperImpl<O>(type, null, null);
        }
        return Mapper.builder(type).automap().build();
    }

    public static <O> Mapper<O> of(@NotNull Class<O> type, @NotNull String columnName) {
        return new OneColumnMapperImpl<O>(Mapper.ensureNativelySupported(type), columnName, null);
    }

    public static <ObjectT, ColumnT> Mapper<ObjectT> of(@NotNull Class<ObjectT> type, @NotNull String columnName, @NotNull TypeConverter<ObjectT, ColumnT> converter) {
        return new OneColumnMapperImpl<ObjectT>(Objects.requireNonNull(type), Objects.requireNonNull(columnName), Objects.requireNonNull(converter));
    }

    public static <O> Mapper<O> of(@NotNull Class<O> type, @NotNull String fieldName, @NotNull String columnName, String ... fieldColumnPairs) {
        if (fieldColumnPairs.length % 2 != 0) {
            throw new IllegalArgumentException("Missed a column name, which the field is mapped to: " + fieldColumnPairs[fieldColumnPairs.length - 1]);
        }
        return Mapper.builder(type).map(Objects.requireNonNull(fieldName), Objects.requireNonNull(columnName), fieldColumnPairs).build();
    }

    public static <O> Mapper<O> of(Function<O, Tuple> objectToRow, Function<Tuple, O> rowToObject) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public static <O> MapperBuilder<O> builder(@NotNull Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            return new MapperBuilder<O>(type, null);
        }
        return new MapperBuilder<O>(type);
    }

    public static <O> Class<O> ensureNativelySupported(@NotNull Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            return type;
        }
        throw new IllegalArgumentException("Class has no native support (type converter required): " + type.getName());
    }

    public static boolean nativelySupported(Class<?> type) {
        return !Objects.requireNonNull(type).isPrimitive() && (String.class == type || UUID.class == type || BitSet.class == type || byte[].class == type || LocalDate.class == type || LocalTime.class == type || LocalDateTime.class == type || Instant.class == type || Number.class.isAssignableFrom(type));
    }

    public Class<T> targetType();
}

