/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.session;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.sql.engine.AsyncCloseable;
import org.apache.ignite.internal.sql.engine.CurrentTimeProvider;
import org.apache.ignite.internal.sql.engine.property.PropertiesHolder;
import org.apache.ignite.internal.sql.engine.session.SessionId;
import org.apache.ignite.lang.IgniteStringFormatter;

public class Session
implements AsyncCloseable {
    private static final long EXPIRED = 0L;
    private final Set<AsyncCloseable> resources = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicReference<CompletableFuture<Void>> closeFutRef = new AtomicReference();
    private final long idleTimeoutMs;
    private final SessionId sessionId;
    private final AtomicLong lastTouched;
    private final PropertiesHolder queryProperties;
    private final CurrentTimeProvider currentTimeProvider;

    public Session(SessionId sessionId, CurrentTimeProvider currentTimeProvider, long idleTimeoutMs, PropertiesHolder queryProperties) {
        this.sessionId = sessionId;
        this.currentTimeProvider = currentTimeProvider;
        this.idleTimeoutMs = idleTimeoutMs;
        this.queryProperties = queryProperties;
        this.lastTouched = new AtomicLong(currentTimeProvider.now());
    }

    public PropertiesHolder queryProperties() {
        return this.queryProperties;
    }

    public SessionId sessionId() {
        return this.sessionId;
    }

    public long idleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public boolean expired() {
        long last = this.lastTouched.get();
        if (last == 0L) {
            return true;
        }
        return this.currentTimeProvider.now() - last > this.idleTimeoutMs && (this.lastTouched.compareAndSet(last, 0L) || this.lastTouched.get() == 0L);
    }

    public boolean touch() {
        long time;
        do {
            if ((time = this.lastTouched.get()) != 0L) continue;
            return false;
        } while (!this.lastTouched.compareAndSet(time, this.currentTimeProvider.now()));
        return true;
    }

    public void registerResource(AsyncCloseable resource) {
        if (!this.lock.readLock().tryLock()) {
            throw new IllegalStateException(IgniteStringFormatter.format((String)"Attempt to register resource to an expired session [{}]", (Object[])new Object[]{this.sessionId}));
        }
        if (this.expired()) {
            this.lock.readLock().unlock();
            throw new IllegalStateException(IgniteStringFormatter.format((String)"Attempt to register resource to an expired session [{}]", (Object[])new Object[]{this.sessionId}));
        }
        try {
            this.resources.add(resource);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void unregisterResource(AsyncCloseable resource) {
        if (!this.lock.readLock().tryLock()) {
            return;
        }
        try {
            this.resources.remove(resource);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.closeFutRef.compareAndSet(null, new CompletableFuture())) {
            this.lock.writeLock().lock();
            this.lastTouched.set(0L);
            CompletableFuture[] futs = new CompletableFuture[this.resources.size()];
            int idx = 0;
            for (AsyncCloseable resource : this.resources) {
                futs[idx++] = resource.closeAsync();
            }
            this.resources.clear();
            CompletableFuture.allOf(futs).thenRun(() -> this.closeFutRef.get().complete(null));
        }
        return this.closeFutRef.get().thenRun(() -> {});
    }
}

