/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.internal.causality.VersionedValue;
import org.apache.ignite.internal.index.Index;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.DefaultValueProvider;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptorImpl;
import org.apache.ignite.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteSchema;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.IgniteTableImpl;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.schema.SchemaUpdateListener;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptorImpl;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSchemaManagerImpl
implements SqlSchemaManager {
    private final VersionedValue<Map<String, IgniteSchema>> schemasVv;
    private final VersionedValue<Map<UUID, InternalIgniteTable>> tablesVv;
    private final VersionedValue<Map<UUID, IgniteIndex>> indicesVv;
    private final TableManager tableManager;
    private final SchemaManager schemaManager;
    private final VersionedValue<SchemaPlus> calciteSchemaVv;
    private final Set<SchemaUpdateListener> listeners = new CopyOnWriteArraySet<SchemaUpdateListener>();
    private final IgniteSpinBusyLock busyLock;

    public SqlSchemaManagerImpl(TableManager tableManager, SchemaManager schemaManager, Consumer<Function<Long, CompletableFuture<?>>> registry, IgniteSpinBusyLock busyLock) {
        this.tableManager = tableManager;
        this.schemaManager = schemaManager;
        this.schemasVv = new VersionedValue(registry, HashMap::new);
        this.tablesVv = new VersionedValue(registry, HashMap::new);
        this.indicesVv = new VersionedValue(registry, HashMap::new);
        this.busyLock = busyLock;
        this.calciteSchemaVv = new VersionedValue(null, () -> {
            SchemaPlus newCalciteSchema = Frameworks.createRootSchema((boolean)false);
            newCalciteSchema.add("PUBLIC", (Schema)new IgniteSchema("PUBLIC"));
            return newCalciteSchema;
        });
        this.schemasVv.whenComplete((token, stringIgniteSchemaMap, throwable) -> {
            if (!busyLock.enterBusy()) {
                this.calciteSchemaVv.completeExceptionally(token.longValue(), (Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
                return;
            }
            try {
                if (throwable != null) {
                    this.calciteSchemaVv.completeExceptionally(token.longValue(), (Throwable)new IgniteInternalException(ErrorGroups.Sql.SCHEMA_EVALUATION_ERR, "Couldn't evaluate sql schemas for causality token: " + token, throwable));
                    return;
                }
                SchemaPlus newCalciteSchema = this.rebuild((Map<String, IgniteSchema>)stringIgniteSchemaMap);
                this.listeners.forEach(SchemaUpdateListener::onSchemaUpdated);
                this.calciteSchemaVv.complete(token.longValue(), (Object)newCalciteSchema);
            }
            finally {
                busyLock.leaveBusy();
            }
        });
    }

    @Override
    public SchemaPlus schema(@Nullable String schema) {
        SchemaPlus schemaPlus = (SchemaPlus)this.calciteSchemaVv.latest();
        return schema != null ? schemaPlus.getSubSchema(schema) : schemaPlus.getSubSchema("PUBLIC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IgniteTable tableById(UUID id, int ver) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            IgniteTable table = (IgniteTable)((Map)this.tablesVv.latest()).get(id);
            if (table == null || ver > table.version()) {
                table = this.awaitLatestTableSchema(id);
            }
            if (table == null) {
                throw new IgniteInternalException(ErrorGroups.Sql.OBJECT_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Table not found [tableId={}]", (Object[])new Object[]{id}));
            }
            if (table.version() < ver) {
                throw new IgniteInternalException(ErrorGroups.Sql.TABLE_VER_NOT_FOUND_ERR, IgniteStringFormatter.format((String)"Table version not found [tableId={}, requiredVer={}, latestKnownVer={}]", (Object[])new Object[]{id, ver, table.version()}));
            }
            IgniteTable igniteTable = table;
            return igniteTable;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void registerListener(SchemaUpdateListener listener) {
        this.listeners.add(listener);
    }

    @Nullable
    private IgniteTable awaitLatestTableSchema(UUID tableId) {
        try {
            TableImpl table = this.tableManager.table(tableId);
            if (table == null) {
                return null;
            }
            table.schemaView().waitLatestSchema();
            return this.convert(table);
        }
        catch (NodeStoppingException e) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<?> onTableCreated(String schemaName, TableImpl table, long causalityToken) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            this.schemasVv.update(causalityToken, (schemas, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture(e);
                }
                HashMap<String, IgniteSchema> res = new HashMap<String, IgniteSchema>((Map<String, IgniteSchema>)schemas);
                IgniteSchema schema = res.compute(schemaName, (k, v) -> v == null ? new IgniteSchema(schemaName) : IgniteSchema.copy(v));
                CompletableFuture<IgniteTableImpl> igniteTableFuture = this.convert(causalityToken, table);
                return this.tablesVv.update(causalityToken, (tables, ex) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                    if (ex != null) {
                        return CompletableFuture.failedFuture(ex);
                    }
                    HashMap resTbls = new HashMap(tables);
                    return igniteTableFuture.thenApply(igniteTable -> {
                        InternalIgniteTable oldTable = resTbls.put(igniteTable.id(), igniteTable);
                        if (oldTable != null) {
                            for (IgniteIndex index : oldTable.indexes().values()) {
                                igniteTable.addIndex(index);
                            }
                        }
                        return resTbls;
                    });
                })).thenCombine(igniteTableFuture, (v, igniteTable) -> {
                    schema.addTable(table.name(), (InternalIgniteTable)igniteTable);
                    return res;
                });
            }));
            CompletableFuture completableFuture = this.calciteSchemaVv.get(causalityToken);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<?> onTableUpdated(String schemaName, TableImpl table, long causalityToken) {
        return this.onTableCreated(schemaName, table, causalityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<?> onTableDropped(String schemaName, String tableName, long causalityToken) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            this.schemasVv.update(causalityToken, (schemas, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture(e);
                }
                HashMap<String, IgniteSchema> res = new HashMap<String, IgniteSchema>((Map<String, IgniteSchema>)schemas);
                IgniteSchema schema = res.compute(schemaName, (k, v) -> v == null ? new IgniteSchema(schemaName) : IgniteSchema.copy(v));
                InternalIgniteTable table = (InternalIgniteTable)schema.getTable(tableName);
                if (table != null) {
                    schema.removeTable(tableName);
                    return this.tablesVv.update(causalityToken, (tables, ex) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                        if (ex != null) {
                            return CompletableFuture.failedFuture(ex);
                        }
                        HashMap resTbls = new HashMap(tables);
                        resTbls.remove(table.id());
                        return CompletableFuture.completedFuture(resTbls);
                    })).thenCompose(tables -> CompletableFuture.completedFuture(res));
                }
                return CompletableFuture.completedFuture(res);
            }));
            CompletableFuture completableFuture = this.calciteSchemaVv.get(causalityToken);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private SchemaPlus rebuild(Map<String, IgniteSchema> schemas) {
        SchemaPlus newCalciteSchema = Frameworks.createRootSchema((boolean)false);
        newCalciteSchema.add("PUBLIC", (Schema)new IgniteSchema("PUBLIC"));
        schemas.forEach((arg_0, arg_1) -> ((SchemaPlus)newCalciteSchema).add(arg_0, arg_1));
        return newCalciteSchema;
    }

    private CompletableFuture<IgniteTableImpl> convert(long causalityToken, TableImpl table) {
        return this.schemaManager.schemaRegistry(causalityToken, table.tableId()).thenApply(schemaRegistry -> (IgniteTableImpl)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.convert(table, (SchemaRegistry)schemaRegistry)));
    }

    private IgniteTableImpl convert(TableImpl table) {
        SchemaRegistry schemaRegistry = this.schemaManager.schemaRegistry(table.tableId());
        return this.convert(table, schemaRegistry);
    }

    private IgniteTableImpl convert(TableImpl table, SchemaRegistry schemaRegistry) {
        SchemaDescriptor descriptor = schemaRegistry.schema();
        List<ColumnDescriptor> colDescriptors = descriptor.columnNames().stream().map(arg_0 -> ((SchemaDescriptor)descriptor).column(arg_0)).sorted(Comparator.comparingInt(Column::columnOrder)).map(col -> new ColumnDescriptorImpl(col.name(), descriptor.isKeyColumn(col.schemaIndex()), col.nullable(), col.columnOrder(), col.schemaIndex(), col.type(), this.convertDefaultValueProvider(col.defaultValueProvider()), () -> ((Column)col).defaultValue())).collect(Collectors.toList());
        return new IgniteTableImpl(new TableDescriptorImpl(colDescriptors), table.internalTable(), schemaRegistry);
    }

    private DefaultValueStrategy convertDefaultValueProvider(DefaultValueProvider defaultValueProvider) {
        return defaultValueProvider.type() == DefaultValueProvider.Type.CONSTANT ? DefaultValueStrategy.DEFAULT_CONSTANT : DefaultValueStrategy.DEFAULT_COMPUTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<?> onIndexCreated(Index<?> index, long causalityToken) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            this.schemasVv.update(causalityToken, (schemas, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture(e);
                }
                String schemaName = "PUBLIC";
                HashMap<String, IgniteSchema> res = new HashMap<String, IgniteSchema>((Map<String, IgniteSchema>)schemas);
                IgniteSchema schema = res.compute(schemaName, (k, v) -> v == null ? new IgniteSchema(schemaName) : IgniteSchema.copy(v));
                return this.tablesVv.update(causalityToken, (tables, tblEx) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                    if (tblEx != null) {
                        return CompletableFuture.failedFuture(tblEx);
                    }
                    HashMap<UUID, InternalIgniteTable> resTbls = new HashMap<UUID, InternalIgniteTable>((Map<UUID, InternalIgniteTable>)tables);
                    InternalIgniteTable table = resTbls.compute(index.tableId(), (k, v) -> IgniteTableImpl.copyOf((IgniteTableImpl)v));
                    IgniteIndex schemaIndex = new IgniteIndex(index);
                    return this.indicesVv.update(causalityToken, (indices, idxEx) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                        if (idxEx != null) {
                            return CompletableFuture.failedFuture(idxEx);
                        }
                        HashMap<UUID, IgniteIndex> resIdxs = new HashMap<UUID, IgniteIndex>((Map<UUID, IgniteIndex>)indices);
                        resIdxs.put(index.id(), schemaIndex);
                        return CompletableFuture.completedFuture(resIdxs);
                    })).thenCompose(ignore -> {
                        String tblName = SqlSchemaManagerImpl.tableNameById(schema, index.tableId());
                        table.addIndex(schemaIndex);
                        schema.addTable(tblName, table);
                        schema.addIndex(index.id(), schemaIndex);
                        return CompletableFuture.completedFuture(resTbls);
                    });
                })).thenCompose(v -> CompletableFuture.completedFuture(res));
            }));
            CompletableFuture completableFuture = this.calciteSchemaVv.get(causalityToken);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static String tableNameById(IgniteSchema schema, UUID tableId) {
        return schema.getTableMap().entrySet().stream().filter(entry -> tableId.equals(((InternalIgniteTable)entry.getValue()).id())).map(Map.Entry::getKey).findFirst().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<?> onIndexDropped(String schemaName, UUID indexId, long causalityToken) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            this.schemasVv.update(causalityToken, (schemas, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture(e);
                }
                HashMap<String, IgniteSchema> res = new HashMap<String, IgniteSchema>((Map<String, IgniteSchema>)schemas);
                IgniteSchema schema = res.compute(schemaName, (k, v) -> v == null ? new IgniteSchema(schemaName) : IgniteSchema.copy(v));
                IgniteIndex rmvIndex = schema.removeIndex(indexId);
                if (rmvIndex != null) {
                    return this.tablesVv.update(causalityToken, (tables, tlbEx) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                        if (tlbEx != null) {
                            return CompletableFuture.failedFuture(tlbEx);
                        }
                        HashMap<UUID, InternalIgniteTable> resTbls = new HashMap<UUID, InternalIgniteTable>((Map<UUID, InternalIgniteTable>)tables);
                        InternalIgniteTable table = resTbls.compute(rmvIndex.index().tableId(), (k, v) -> IgniteTableImpl.copyOf((IgniteTableImpl)v));
                        table.removeIndex(rmvIndex.name());
                        return this.indicesVv.update(causalityToken, (indices, idxEx) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                            if (idxEx != null) {
                                return CompletableFuture.failedFuture(idxEx);
                            }
                            HashMap resIdxs = new HashMap(indices);
                            IgniteIndex rmvIdx = (IgniteIndex)resIdxs.remove(indexId);
                            assert (table.id().equals(rmvIdx.index().tableId()));
                            String tblName = SqlSchemaManagerImpl.tableNameById(schema, rmvIdx.index().tableId());
                            schema.addTable(tblName, table);
                            return CompletableFuture.completedFuture(resIdxs);
                        })).thenCompose(v -> CompletableFuture.completedFuture(resTbls));
                    })).thenCompose(v -> CompletableFuture.completedFuture(res));
                }
                return CompletableFuture.completedFuture(res);
            }));
            CompletableFuture completableFuture = this.calciteSchemaVv.get(causalityToken);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

