/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.sql.engine.message.InboxCloseMessage;
import org.apache.ignite.internal.sql.engine.message.InboxCloseMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class InboxCloseMessageImpl
implements InboxCloseMessage {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final long exchangeId;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final UUID queryId;

    private InboxCloseMessageImpl(long exchangeId, long fragmentId, UUID queryId) {
        this.exchangeId = exchangeId;
        this.fragmentId = fragmentId;
        this.queryId = queryId;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(InboxCloseMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InboxCloseMessageImpl otherMessage = (InboxCloseMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && this.exchangeId == otherMessage.exchangeId && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.exchangeId, this.fragmentId, this.queryId);
        return result;
    }

    public static InboxCloseMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements InboxCloseMessageBuilder {
        private long exchangeId;
        private long fragmentId;
        private UUID queryId;

        private Builder() {
        }

        @Override
        public InboxCloseMessageBuilder exchangeId(long exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        @Override
        public InboxCloseMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public InboxCloseMessageBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public long exchangeId() {
            return this.exchangeId;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public InboxCloseMessage build() {
            return new InboxCloseMessageImpl(this.exchangeId, this.fragmentId, this.queryId);
        }
    }
}

