/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.util.CollectionUtils;

public class FilterNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final Predicate<RowT> pred;
    private final Deque<RowT> inBuf = new ArrayDeque<RowT>(512);
    private int requested;
    private int waiting;
    private boolean inLoop;

    public FilterNode(ExecutionContext<RowT> ctx, RelDataType rowType, Predicate<RowT> pred) {
        super(ctx, rowType);
        this.pred = pred;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::doFilter, this::onError);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        if (this.pred.test(row)) {
            this.inBuf.add(row);
        }
        this.filter();
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.filter();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.inBuf.clear();
    }

    private void doFilter() throws Exception {
        this.checkState();
        this.filter();
    }

    private void filter() throws Exception {
        this.inLoop = true;
        try {
            while (this.requested > 0 && !this.inBuf.isEmpty()) {
                this.checkState();
                --this.requested;
                this.downstream().push(this.inBuf.remove());
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.inBuf.isEmpty() && this.waiting == 0) {
            this.waiting = 512;
            this.source().request(512);
        }
        if (this.waiting == -1 && this.requested > 0) {
            assert (this.inBuf.isEmpty());
            this.requested = 0;
            this.downstream().end();
        }
    }
}

