/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.index.IndexManager;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.exec.AsyncWrapper;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionCancelledException;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite.internal.sql.engine.exec.LogicalRelImplementor;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.RemoteFragmentKey;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.ddl.DdlCommandHandler;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.AsyncRootNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.externalize.RelJsonReader;
import org.apache.ignite.internal.sql.engine.message.ErrorMessage;
import org.apache.ignite.internal.sql.engine.message.MessageService;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequest;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponse;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.metadata.FragmentDescription;
import org.apache.ignite.internal.sql.engine.metadata.MappingService;
import org.apache.ignite.internal.sql.engine.metadata.MappingServiceImpl;
import org.apache.ignite.internal.sql.engine.metadata.RemoteException;
import org.apache.ignite.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.FragmentPlan;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class ExecutionServiceImpl<RowT>
implements ExecutionService,
TopologyEventHandler {
    private static final IgniteLogger LOG = Loggers.forClass(ExecutionServiceImpl.class);
    private static final SqlQueryMessagesFactory FACTORY = new SqlQueryMessagesFactory();
    private final MessageService msgSrvc;
    private final ClusterNode localNode;
    private final SqlSchemaManager sqlSchemaManager;
    private final QueryTaskExecutor taskExecutor;
    private final MappingService mappingSrvc;
    private final ExchangeService exchangeSrvc;
    private final RowHandler<RowT> handler;
    private final DdlCommandHandler ddlCmdHnd;
    private final ImplementorFactory<RowT> implementorFactory;
    private final Map<UUID, DistributedQueryManager> queryManagerMap = new ConcurrentHashMap<UUID, DistributedQueryManager>();

    public static <RowT> ExecutionServiceImpl<RowT> create(TopologyService topSrvc, MessageService msgSrvc, SqlSchemaManager sqlSchemaManager, TableManager tblManager, IndexManager indexManager, QueryTaskExecutor taskExecutor, RowHandler<RowT> handler, MailboxRegistry mailboxRegistry, ExchangeService exchangeSrvc, DataStorageManager dataStorageManager) {
        return new ExecutionServiceImpl<RowT>(topSrvc.localMember(), msgSrvc, new MappingServiceImpl(topSrvc), sqlSchemaManager, new DdlCommandHandler(tblManager, indexManager, dataStorageManager), taskExecutor, handler, exchangeSrvc, ctx -> new LogicalRelImplementor(ctx, cacheId -> Objects::hashCode, mailboxRegistry, exchangeSrvc));
    }

    ExecutionServiceImpl(ClusterNode localNode, MessageService msgSrvc, MappingService mappingSrvc, SqlSchemaManager sqlSchemaManager, DdlCommandHandler ddlCmdHnd, QueryTaskExecutor taskExecutor, RowHandler<RowT> handler, ExchangeService exchangeSrvc, ImplementorFactory<RowT> implementorFactory) {
        this.localNode = localNode;
        this.handler = handler;
        this.msgSrvc = msgSrvc;
        this.mappingSrvc = mappingSrvc;
        this.sqlSchemaManager = sqlSchemaManager;
        this.taskExecutor = taskExecutor;
        this.exchangeSrvc = exchangeSrvc;
        this.ddlCmdHnd = ddlCmdHnd;
        this.implementorFactory = implementorFactory;
    }

    @Override
    public void start() {
        this.msgSrvc.register((n, m) -> this.onMessage(n, (QueryStartRequest)m), (short)0);
        this.msgSrvc.register((n, m) -> this.onMessage(n, (QueryStartResponse)m), (short)1);
        this.msgSrvc.register((n, m) -> this.onMessage(n, (QueryCloseMessage)m), (short)6);
        this.msgSrvc.register((n, m) -> this.onMessage(n, (ErrorMessage)m), (short)2);
    }

    private AsyncCursor<List<Object>> executeQuery(BaseQueryContext ctx, MultiStepPlan plan) {
        InternalTransaction tx = ctx.transaction();
        DistributedQueryManager queryManager = new DistributedQueryManager(ctx, tx);
        DistributedQueryManager old = this.queryManagerMap.put(ctx.queryId(), queryManager);
        assert (old == null);
        ctx.cancel().add(() -> queryManager.close(false));
        return queryManager.execute(plan);
    }

    private BaseQueryContext createQueryContext(UUID queryId, @Nullable String schema, Object[] params, HybridTimestamp txTime) {
        return BaseQueryContext.builder().queryId(queryId).parameters(params).frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(this.sqlSchemaManager.schema(schema)).build()).logger(LOG).transactionTime(txTime).build();
    }

    private QueryPlan prepareFragment(String jsonFragment) {
        return new FragmentPlan((IgniteRel)RelJsonReader.fromJson(this.sqlSchemaManager, jsonFragment));
    }

    @Override
    public AsyncCursor<List<Object>> executePlan(QueryPlan plan, BaseQueryContext ctx) {
        switch (plan.type()) {
            case DML: 
            case QUERY: {
                return this.executeQuery(ctx, (MultiStepPlan)plan);
            }
            case EXPLAIN: {
                return this.executeExplain((ExplainPlan)plan);
            }
            case DDL: {
                return this.executeDdl((DdlPlan)plan);
            }
        }
        throw new AssertionError((Object)("Unexpected plan type: " + plan));
    }

    public CompletableFuture<?> cancel(UUID qryId) {
        DistributedQueryManager mgr = this.queryManagerMap.get(qryId);
        if (mgr == null) {
            return CompletableFuture.completedFuture(null);
        }
        return mgr.close(true);
    }

    private AsyncCursor<List<Object>> executeDdl(DdlPlan plan) {
        CompletionStage ret = ((CompletableFuture)this.ddlCmdHnd.handle(plan.command()).thenApply(applied -> List.of(List.of(applied)).iterator())).exceptionally(th -> {
            throw ExecutionServiceImpl.convertDdlException(th);
        });
        return new AsyncWrapper<List<Object>>((CompletableFuture<Iterator<List<Object>>>)ret, Runnable::run);
    }

    private static RuntimeException convertDdlException(Throwable e) {
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        if (e instanceof ConfigurationChangeException) {
            assert (e.getCause() != null);
            e = e.getCause();
        }
        if (e instanceof IgniteInternalCheckedException) {
            return new IgniteInternalException(ErrorGroups.Sql.DDL_EXEC_ERR, "Failed to execute DDL statement [stmt=, err=" + e.getMessage() + "]", e);
        }
        return e instanceof RuntimeException ? (RuntimeException)e : new SqlException(ErrorGroups.Sql.DDL_EXEC_ERR, e);
    }

    private AsyncCursor<List<Object>> executeExplain(ExplainPlan plan) {
        List<List<String>> res = List.of(List.of(plan.plan()));
        return new AsyncWrapper<List<Object>>(res.iterator());
    }

    private void onMessage(String nodeId, QueryStartRequest msg) {
        assert (nodeId != null && msg != null);
        DistributedQueryManager queryManager = this.queryManagerMap.computeIfAbsent(msg.queryId(), key -> {
            BaseQueryContext ctx = this.createQueryContext((UUID)key, msg.schema(), msg.parameters(), msg.txTime());
            return new DistributedQueryManager(ctx);
        });
        queryManager.submitFragment(nodeId, msg.root(), msg.fragmentDescription());
    }

    private void onMessage(String nodeId, QueryStartResponse msg) {
        assert (nodeId != null && msg != null);
        DistributedQueryManager dqm = this.queryManagerMap.get(msg.queryId());
        if (dqm != null) {
            dqm.acknowledgeFragment(nodeId, msg.fragmentId(), msg.error());
        }
    }

    private void onMessage(String nodeId, ErrorMessage msg) {
        assert (nodeId != null && msg != null);
        DistributedQueryManager dqm = this.queryManagerMap.get(msg.queryId());
        if (dqm != null) {
            RemoteException e = new RemoteException(nodeId, msg.queryId(), msg.fragmentId(), msg.error());
            dqm.onError(e);
        }
    }

    private void onMessage(String nodeId, QueryCloseMessage msg) {
        assert (nodeId != null && msg != null);
        DistributedQueryManager dqm = this.queryManagerMap.get(msg.queryId());
        if (dqm != null) {
            dqm.close(true);
        }
    }

    @Override
    public void stop() throws Exception {
        CompletableFuture.allOf((CompletableFuture[])this.queryManagerMap.values().stream().filter(mgr -> mgr.rootFragmentId != null).map(mgr -> mgr.close(true)).toArray(CompletableFuture[]::new)).join();
    }

    public void onAppeared(ClusterNode member) {
    }

    public void onDisappeared(ClusterNode member) {
        this.queryManagerMap.values().forEach(qm -> qm.onNodeLeft(member.id()));
    }

    public List<AbstractNode<?>> localFragments(UUID queryId) {
        DistributedQueryManager mgr = this.queryManagerMap.get(queryId);
        if (mgr == null) {
            return List.of();
        }
        return mgr.localFragments();
    }

    @FunctionalInterface
    static interface ImplementorFactory<RowT> {
        public LogicalRelImplementor<RowT> create(ExecutionContext<RowT> var1);
    }

    class DistributedQueryManager {
        private final BaseQueryContext ctx;
        private final CompletableFuture<Void> cancelFut = new CompletableFuture();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final Map<RemoteFragmentKey, CompletableFuture<Void>> remoteFragmentInitCompletion = new ConcurrentHashMap<RemoteFragmentKey, CompletableFuture<Void>>();
        private final Queue<AbstractNode<RowT>> localFragments = new LinkedBlockingQueue();
        private final CompletableFuture<AsyncRootNode<RowT, List<Object>>> root;
        private volatile Long rootFragmentId = null;
        @Nullable
        private InternalTransaction tx;

        private DistributedQueryManager(@Nullable BaseQueryContext ctx, InternalTransaction tx) {
            this(ctx);
            this.tx = tx;
        }

        private DistributedQueryManager(BaseQueryContext ctx) {
            this.ctx = ctx;
            CompletableFuture root = new CompletableFuture();
            root.exceptionally(t -> {
                this.close(true);
                return null;
            });
            this.root = root;
        }

        private List<AbstractNode<?>> localFragments() {
            return List.copyOf(this.localFragments);
        }

        private void sendFragment(String targetNodeId, Fragment fragment, FragmentDescription desc) throws IgniteInternalCheckedException {
            QueryStartRequest req = FACTORY.queryStartRequest().queryId(this.ctx.queryId()).fragmentId(fragment.fragmentId()).schema(this.ctx.schemaName()).root(fragment.serialized()).fragmentDescription(desc).parameters(this.ctx.parameters()).txTime(this.ctx.transactionTime()).build();
            CompletableFuture<Object> fut = new CompletableFuture<Object>();
            this.remoteFragmentInitCompletion.put(new RemoteFragmentKey(targetNodeId, fragment.fragmentId()), fut);
            try {
                ExecutionServiceImpl.this.msgSrvc.send(targetNodeId, req);
            }
            catch (Exception ex) {
                fut.complete(null);
                if (fragment.rootFragment()) {
                    this.root.completeExceptionally(ex);
                }
                throw ex;
            }
        }

        private void acknowledgeFragment(String nodeId, long fragmentId, @Nullable Throwable ex) {
            if (ex != null) {
                Long rootFragmentId0 = this.rootFragmentId;
                if (rootFragmentId0 != null && fragmentId == rootFragmentId0) {
                    this.root.completeExceptionally(ex);
                } else {
                    this.root.thenAccept(root -> {
                        root.onError(ex);
                        this.close(true);
                    });
                }
            }
            this.remoteFragmentInitCompletion.get(new RemoteFragmentKey(nodeId, fragmentId)).complete(null);
        }

        private void onError(RemoteException ex) {
            this.root.thenAccept(root -> {
                root.onError(ex);
                this.close(true);
            });
        }

        private void onNodeLeft(String nodeId) {
            this.remoteFragmentInitCompletion.entrySet().stream().filter(e -> nodeId.equals(((RemoteFragmentKey)e.getKey()).nodeId())).forEach(e -> ((CompletableFuture)e.getValue()).completeExceptionally((Throwable)new IgniteInternalException(ErrorGroups.Sql.NODE_LEFT_ERR, "Node left the cluster [nodeId=" + nodeId + "]")));
        }

        private void executeFragment(FragmentPlan plan, ExecutionContext<RowT> ectx) {
            String origNodeId = ectx.originatingNodeId();
            AbstractNode node = (AbstractNode)ExecutionServiceImpl.this.implementorFactory.create(ectx).go(plan.root());
            this.localFragments.add(node);
            if (!(node instanceof Outbox)) {
                Function internalTypeConverter = TypeUtils.resultTypeConverter(ectx, plan.root().getRowType());
                AsyncRootNode<Object, List> rootNode = new AsyncRootNode<Object, List>(node, inRow -> {
                    inRow = internalTypeConverter.apply(inRow);
                    int rowSize = ectx.rowHandler().columnCount(inRow);
                    ArrayList<Object> res = new ArrayList<Object>(rowSize);
                    for (int i = 0; i < rowSize; ++i) {
                        res.add(ectx.rowHandler().get(i, inRow));
                    }
                    return res;
                });
                node.onRegister(rootNode);
                this.root.complete(rootNode);
            }
            try {
                ExecutionServiceImpl.this.msgSrvc.send(origNodeId, FACTORY.queryStartResponse().queryId(ectx.queryId()).fragmentId(ectx.fragmentId()).build());
            }
            catch (IgniteInternalCheckedException e) {
                throw new IgniteInternalException(ErrorGroups.Sql.MESSAGE_SEND_ERR, "Failed to send reply. [nodeId=" + origNodeId + "]", (Throwable)e);
            }
            if (node instanceof Outbox) {
                ((Outbox)node).init();
            }
        }

        private ExecutionContext<RowT> createContext(String initiatorNodeId, FragmentDescription desc) {
            return new ExecutionContext(this.ctx, ExecutionServiceImpl.this.taskExecutor, this.ctx.queryId(), ExecutionServiceImpl.this.localNode, initiatorNodeId, desc, ExecutionServiceImpl.this.handler, Commons.parametersMap(this.ctx.parameters()), this.tx);
        }

        private void submitFragment(String initiatorNode, String fragmentString, FragmentDescription desc) {
            try {
                QueryPlan qryPlan = ExecutionServiceImpl.this.prepareFragment(fragmentString);
                FragmentPlan plan = (FragmentPlan)qryPlan;
                this.executeFragment(plan, this.createContext(initiatorNode, desc));
            }
            catch (Throwable ex) {
                LOG.debug("Unable to start query fragment", ex);
                try {
                    ExecutionServiceImpl.this.msgSrvc.send(initiatorNode, FACTORY.queryStartResponse().queryId(this.ctx.queryId()).fragmentId(desc.fragmentId()).error(ex).build());
                }
                catch (Exception e) {
                    LOG.info("Unable to send error message", (Throwable)e);
                    this.close(true);
                }
            }
        }

        private AsyncCursor<List<Object>> execute(MultiStepPlan plan) {
            ExecutionServiceImpl.this.taskExecutor.execute(() -> {
                plan.init(ExecutionServiceImpl.this.mappingSrvc, new MappingQueryContext(ExecutionServiceImpl.this.localNode.id()));
                List<Fragment> fragments = plan.fragments();
                assert (!CollectionUtils.nullOrEmpty(fragments) && fragments.get(0).rootFragment()) : fragments;
                try {
                    for (Fragment fragment : fragments) {
                        if (fragment.rootFragment()) {
                            assert (this.rootFragmentId == null);
                            this.rootFragmentId = fragment.fragmentId();
                        }
                        FragmentDescription fragmentDesc = new FragmentDescription(fragment.fragmentId(), plan.mapping(fragment), plan.target(fragment), (Long2ObjectMap<List<String>>)plan.remotes(fragment));
                        for (String nodeId : fragmentDesc.nodeIds()) {
                            this.sendFragment(nodeId, fragment, fragmentDesc);
                        }
                    }
                }
                catch (Throwable e) {
                    this.root.thenAccept(root -> root.onError(e));
                }
            });
            return new AsyncCursor<List<Object>>(){

                @Override
                public CompletableFuture<AsyncCursor.BatchedResult<List<Object>>> requestNextAsync(int rows) {
                    return DistributedQueryManager.this.root.thenCompose(cur -> {
                        CompletableFuture fut = cur.requestNextAsync(rows);
                        fut.thenAccept(batch -> {
                            if (!batch.hasMore()) {
                                DistributedQueryManager.this.close(false);
                            }
                        });
                        return fut;
                    });
                }

                @Override
                public CompletableFuture<Void> closeAsync() {
                    return DistributedQueryManager.this.root.thenCompose(none -> DistributedQueryManager.this.close(false));
                }
            };
        }

        private CompletableFuture<Void> close(boolean cancel) {
            if (!this.cancelled.compareAndSet(false, true)) {
                return this.cancelFut.thenApply(Function.identity());
            }
            CompletableFuture<Void> start = new CompletableFuture<Void>();
            ((CompletableFuture)start.thenCompose(none -> {
                if (!this.root.completeExceptionally((Throwable)((Object)new ExecutionCancelledException())) && !this.root.isCompletedExceptionally()) {
                    if (cancel) {
                        return this.root.thenAccept(root -> root.onError((Throwable)((Object)new ExecutionCancelledException())));
                    }
                    return this.root.thenCompose(AsyncRootNode::closeAsync);
                }
                return CompletableFuture.completedFuture(null);
            })).thenCompose(tmp -> {
                HashMap<String, List> requestsPerNode = new HashMap<String, List>();
                for (Map.Entry<RemoteFragmentKey, CompletableFuture<Void>> entry : this.remoteFragmentInitCompletion.entrySet()) {
                    requestsPerNode.computeIfAbsent(entry.getKey().nodeId(), key -> new ArrayList()).add(entry.getValue());
                }
                ArrayList<CompletionStage> cancelFuts = new ArrayList<CompletionStage>();
                for (Map.Entry entry : requestsPerNode.entrySet()) {
                    String string = (String)entry.getKey();
                    if (!ExecutionServiceImpl.this.exchangeSrvc.alive(string)) continue;
                    cancelFuts.add(CompletableFuture.allOf(((List)entry.getValue()).toArray(new CompletableFuture[0])).handle((none2, t) -> {
                        try {
                            ExecutionServiceImpl.this.exchangeSrvc.closeQuery(nodeId, this.ctx.queryId());
                        }
                        catch (IgniteInternalCheckedException e) {
                            throw new IgniteInternalException(ErrorGroups.Sql.MESSAGE_SEND_ERR, "Failed to send cancel message. [nodeId=" + nodeId + "]", (Throwable)e);
                        }
                        return null;
                    }));
                }
                if (cancel) {
                    ExecutionCancelledException executionCancelledException = new ExecutionCancelledException();
                    for (AbstractNode abstractNode : this.localFragments) {
                        abstractNode.context().execute(() -> node.onError((Throwable)((Object)ex)), abstractNode::onError);
                    }
                }
                CompletableFuture<Void> completableFuture = CompletableFuture.allOf(cancelFuts.toArray(new CompletableFuture[0]));
                CompletionStage completionStage = completableFuture.thenRun(() -> {
                    ExecutionServiceImpl.this.queryManagerMap.remove(this.ctx.queryId());
                    try {
                        this.ctx.cancel().cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.cancelFut.complete(null);
                });
                return completableFuture.thenCombine(completionStage, (none1, none2) -> null);
            });
            start.completeAsync(() -> null, ExecutionServiceImpl.this.taskExecutor);
            return this.cancelFut.thenApply(Function.identity());
        }
    }
}

