/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.Context;
import org.apache.ignite.internal.util.ArrayUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class QueryContext
implements Context {
    private final Object[] params;

    private QueryContext(Object[] params) {
        this.params = params;
    }

    public <C> @Nullable C unwrap(Class<C> cls) {
        if (Object[].class == cls) {
            return cls.cast(this.params);
        }
        return Arrays.stream(this.params).filter(cls::isInstance).findFirst().map(cls::cast).orElse(null);
    }

    public static QueryContext of(Object ... params) {
        return !ArrayUtils.nullOrEmpty((Object[])params) ? new QueryContext(QueryContext.build(null, params).toArray()) : new QueryContext(ArrayUtils.OBJECT_EMPTY_ARRAY);
    }

    private static List<Object> build(List<Object> dst, Object[] src) {
        if (dst == null) {
            dst = new ArrayList<Object>();
        }
        for (Object obj : src) {
            if (obj == null) continue;
            if (obj.getClass() == QueryContext.class) {
                QueryContext.build(dst, ((QueryContext)obj).params);
                continue;
            }
            dst.add(obj);
        }
        return dst;
    }
}

