/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.configuration;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;

@Controller(value="/management/v1/configuration/node")
@Tag(name="nodeConfiguration")
public interface NodeConfigurationApi {
    @Operation(operationId="getNodeConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}, description="Whole node configuration"), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"text/plain", "application/problem+json"})
    @Get
    public String getConfiguration();

    @Operation(operationId="getNodeConfigurationByPath")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}, description="Configuration represented by path"), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"text/plain", "application/problem+json"})
    @Get(value="/{path}")
    public String getConfigurationByPath(@PathVariable(value="path") String var1);

    @Operation(operationId="updateNodeConfiguration")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Configuration updated"), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Incorrect configuration", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"text/plain"})
    @Produces(value={"application/problem+json"})
    @Patch
    public CompletableFuture<Void> updateConfiguration(@Body String var1);
}

