/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.index.SortedIndex;
import org.apache.ignite.internal.index.SortedIndexDescriptor;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class SortedIndexImpl
implements SortedIndex {
    private final UUID id;
    private final InternalTable table;
    private final SortedIndexDescriptor descriptor;

    public SortedIndexImpl(UUID id, TableImpl table, SortedIndexDescriptor descriptor) {
        this.id = Objects.requireNonNull(id, "id");
        this.table = Objects.requireNonNull(table.internalTable(), "table");
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor");
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public UUID tableId() {
        return this.table.tableId();
    }

    @Override
    public String name() {
        return this.descriptor.name();
    }

    @Override
    public SortedIndexDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public Flow.Publisher<BinaryRow> lookup(int partId, InternalTransaction tx, BinaryTuple key, BitSet columns) {
        return this.table.lookup(partId, tx, this.id, key, columns);
    }

    @Override
    public Flow.Publisher<BinaryRow> lookup(int partId, HybridTimestamp timestamp, ClusterNode recipientNode, BinaryTuple key, BitSet columns) {
        return this.table.lookup(partId, timestamp, recipientNode, this.id, key, columns);
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, InternalTransaction tx, BinaryTuplePrefix leftBound, BinaryTuplePrefix rightBound, int flags, BitSet columnsToInclude) {
        return this.table.scan(partId, tx, this.id, leftBound, rightBound, flags, columnsToInclude);
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, HybridTimestamp readTimestamp, ClusterNode recipientNode, @Nullable BinaryTuplePrefix leftBound, @Nullable BinaryTuplePrefix rightBound, int flags, BitSet columnsToInclude) {
        return this.table.scan(partId, readTimestamp, recipientNode, this.id, leftBound, rightBound, flags, columnsToInclude);
    }
}

