/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.freelist;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.storage.pagememory.index.freelist.io.IndexColumnsDataIo;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class IndexColumns
implements Storable {
    public static final int SIZE_OFFSET = 0;
    public static final int VALUE_OFFSET = 4;
    private final int partitionId;
    private long link = 0L;
    @Nullable
    private final ByteBuffer valueBuffer;

    public IndexColumns(int partitionId, @Nullable ByteBuffer valueBuffer) {
        this.partitionId = partitionId;
        this.valueBuffer = valueBuffer;
    }

    public IndexColumns(int partitionId, long link, @Nullable ByteBuffer valueBuffer) {
        this.partitionId = partitionId;
        this.link = link;
        this.valueBuffer = valueBuffer;
    }

    public int valueSize() {
        assert (this.valueBuffer != null);
        return this.valueBuffer.limit();
    }

    public ByteBuffer valueBuffer() {
        return this.valueBuffer;
    }

    public void link(long link) {
        this.link = link;
    }

    public long link() {
        return this.link;
    }

    public int partition() {
        return this.partitionId;
    }

    public int size() throws IgniteInternalCheckedException {
        return 4 + this.valueSize();
    }

    public int headerSize() {
        return 5;
    }

    public IoVersions<? extends AbstractDataPageIo<?>> ioVersions() {
        return IndexColumnsDataIo.VERSIONS;
    }
}

