/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.engine;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.configuration.index.TableIndexConfiguration;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.jetbrains.annotations.Nullable;

public interface MvTableStorage {
    public MvPartitionStorage getOrCreateMvPartition(int var1) throws StorageException;

    @Nullable
    public MvPartitionStorage getMvPartition(int var1);

    public CompletableFuture<Void> destroyPartition(int var1) throws StorageException;

    default public IndexStorage getOrCreateIndex(int partitionId, UUID indexId) {
        TableIndexConfiguration indexConfig = (TableIndexConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)this.tablesConfiguration().indexes(), (UUID)indexId);
        if (indexConfig == null) {
            throw new StorageException(String.format("Index configuration for \"%s\" could not be found", indexId));
        }
        switch ((String)indexConfig.type().value()) {
            case "HASH": {
                return this.getOrCreateHashIndex(partitionId, indexId);
            }
            case "SORTED": {
                return this.getOrCreateSortedIndex(partitionId, indexId);
            }
        }
        throw new StorageException("Unknown index type: " + (String)indexConfig.type().value());
    }

    public SortedIndexStorage getOrCreateSortedIndex(int var1, UUID var2);

    public HashIndexStorage getOrCreateHashIndex(int var1, UUID var2);

    public CompletableFuture<Void> destroyIndex(UUID var1);

    public boolean isVolatile();

    public TableConfiguration configuration();

    public TablesConfiguration tablesConfiguration();

    public void start() throws StorageException;

    public void stop() throws StorageException;

    public void destroy() throws StorageException;
}

